/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.database;

import com.sysranger.common.srjson.SRJson;
import com.sysranger.common.srjson.SRJsonNode;
import com.sysranger.common.utils.SRCloser;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class QueryResult {
    public ResultSet rst = null;
    public Statement statement = null;
    public boolean error = false;
    public String errorMessage = "";
    public String query = "";
    public long id;
    public long time = System.currentTimeMillis();
    public Throwable exception = null;

    public boolean isEmpty() {
        if (this.error) {
            return true;
        }
        if (this.rst == null) {
            return true;
        }
        try {
            if (!this.rst.isBeforeFirst() && this.rst.getRow() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    public int getFirstInt() {
        int n = -1;
        try {
            if (!this.rst.next()) {
                return -1;
            }
            n = this.rst.getInt(1);
            return n;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return n;
        }
    }

    public int getInt(String string) {
        try {
            return this.rst.getInt(string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return -1;
        }
    }

    public byte getByte(String string) {
        try {
            return this.rst.getByte(string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return 0;
        }
    }

    public boolean getBoolean(String string) {
        try {
            return this.rst.getBoolean(string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    public String getString(String string) {
        try {
            return this.rst.getString(string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    public Long getLong(String string) {
        try {
            return this.rst.getLong(string);
        }
        catch (SQLException sQLException) {
            return 0L;
        }
    }

    public String getFirstString() {
        String string = "";
        try {
            if (!this.rst.next()) {
                return "";
            }
            string = this.rst.getString(1);
            return string;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return string;
        }
    }

    public void close() {
        SRCloser.close(this.statement);
        SRCloser.close(this.rst);
        this.statement = null;
        this.rst = null;
    }

    public boolean next() {
        try {
            return this.rst.next();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public static QueryResult error(String string) {
        QueryResult queryResult = new QueryResult();
        queryResult.error = true;
        queryResult.errorMessage = string;
        return queryResult;
    }

    public SRJson toJSON() {
        return this.toJSON(null, 0, false);
    }

    public SRJson toJSON(String string) {
        return this.toJSON(string, 0, false);
    }

    public SRJson toJSON(QueryResult queryResult) {
        return this.toJSON("rows", 0, false);
    }

    public SRJson toJSON(String string, int n) {
        return this.toJSON(string, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SRJson toJSON(String string, int n, boolean bl) {
        if (this.rst == null) {
            return SRJson.error("Empty");
        }
        if (string == null) {
            string = "rows";
        }
        SRJson sRJson = new SRJson();
        sRJson.add("query", this.query);
        SRJsonNode sRJsonNode = sRJson.addArray(string);
        SRJsonNode sRJsonNode2 = sRJson.addArray("columns");
        int n2 = 0;
        try {
            ResultSetMetaData resultSetMetaData = this.rst.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            if (bl) {
                for (int i = 1; i <= n3; ++i) {
                    SRJsonNode sRJsonNode3 = new SRJsonNode();
                    sRJsonNode3.add("name", resultSetMetaData.getColumnName(i));
                    sRJsonNode3.add("label", resultSetMetaData.getColumnLabel(i));
                    sRJsonNode3.add("class", resultSetMetaData.getColumnClassName(i));
                    sRJsonNode2.addToArray(sRJsonNode3);
                }
            }
            while (this.rst.next()) {
                SRJsonNode sRJsonNode4 = new SRJsonNode("row");
                for (int i = 1; i <= n3; ++i) {
                    String string2 = resultSetMetaData.getColumnLabel(i);
                    Object object = this.rst.getObject(string2);
                    if (string2.equals("pass")) {
                        object = "*****";
                    }
                    sRJsonNode4.add(string2, object);
                }
                sRJsonNode.addToArray(sRJsonNode4);
                if (n <= 0 || ++n2 <= n) continue;
                break;
            }
            sRJson.add("rowcount", n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SRJson sRJson2 = SRJson.error(exception.getMessage());
            return sRJson2;
        }
        finally {
            this.close();
        }
        return sRJson;
    }
}

