/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.utils;

import com.sysranger.common.app.SRApp;
import com.sysranger.common.utils.SRLogger;

public class Debugger {
    public static boolean debug = false;
    public static SRLogger logger;

    public static boolean print(String string) {
        System.out.println(string);
        return true;
    }

    public static boolean print(String string, String string2) {
        if (debug) {
            System.out.println(string + " - " + string2);
            return true;
        }
        System.out.println(string2);
        return true;
    }

    public static boolean error(String string) {
        System.err.println("[ERROR] " + string);
        return false;
    }

    public static boolean error(Throwable throwable) {
        System.err.println("[ERROR] " + throwable.getMessage());
        return false;
    }

    public static void info(String string) {
        System.err.println("[INFO]  " + string);
    }

    public static boolean log(String string) {
        System.err.println("[INFO]  " + string);
        return true;
    }

    public static boolean debug(Throwable throwable) {
        if (!debug) {
            return false;
        }
        throwable.printStackTrace();
        return false;
    }

    public static boolean debug(String string) {
        if (!debug) {
            return false;
        }
        System.err.println("[ERROR] " + string);
        return false;
    }

    public static boolean trace(Throwable throwable) {
        throwable.printStackTrace();
        return false;
    }

    public static boolean traceAllLines(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            System.err.println(stackTraceElement.getClassName() + " " + stackTraceElement.getMethodName() + " " + stackTraceElement.getLineNumber());
        }
        return false;
    }

    public static boolean exception(Throwable throwable) {
        if (debug) {
            throwable.printStackTrace();
        } else {
            System.err.println("[ERROR] " + throwable.getMessage());
        }
        return false;
    }

    public static void init(SRApp sRApp) {
        logger = new SRLogger(sRApp);
    }

    public static void dispose() {
        if (logger != null) {
            logger.dispose();
        }
        logger = null;
    }
}

