/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.logviewer;

import com.sysranger.common.database.SRLogEntry;
import com.sysranger.logviewer.GUIMain;
import com.sysranger.logviewer.LogViewer;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class TrayManager {
    private JFrame frame;
    private TrayIcon trayIcon;
    private SystemTray tray;
    private boolean traySupported = true;
    private GUIMain gui;
    private LogViewer manager;

    public TrayManager(GUIMain gUIMain) {
        this.gui = gUIMain;
        this.manager = gUIMain.getManager();
        this.frame = gUIMain;
        this.traySupported = SystemTray.isSupported();
        if (!this.traySupported) {
            this.log("SystemTray is not supported");
            this.setDefaultExit(this.traySupported);
            return;
        }
        this.tray = SystemTray.getSystemTray();
        Image image = Toolkit.getDefaultToolkit().getImage("www/images/tray.png");
        ActionListener actionListener = new ActionListener(this){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Exiting....");
                System.exit(0);
            }
        };
        PopupMenu popupMenu = new PopupMenu();
        MenuItem menuItem = new MenuItem("Exit");
        menuItem.addActionListener(actionListener);
        MenuItem menuItem2 = new MenuItem("Open");
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrayManager.this.show();
            }
        });
        popupMenu.add(menuItem2);
        popupMenu.add(menuItem);
        this.trayIcon = new TrayIcon(image, this.manager.name, popupMenu);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrayManager.this.show();
            }
        });
        try {
            this.tray.add(this.trayIcon);
            this.log("GUI-added to SystemTray");
        }
        catch (Exception exception) {
            this.log("GUI-unable to add to tray");
        }
        this.setDefaultExit(this.traySupported);
    }

    private void setDefaultExit(final boolean bl) {
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (!bl) {
                    return;
                }
                TrayManager.this.hide();
            }
        });
    }

    private void log(String string) {
        SRLogEntry sRLogEntry = new SRLogEntry(0, 0L, string);
        this.gui.log(sRLogEntry);
    }

    private void show() {
        this.manager.read(true);
        this.frame.setVisible(true);
        this.frame.setExtendedState(0);
        this.log("Viewer is visible");
    }

    private void hide() {
        this.frame.setVisible(false);
        this.log("Viewer is hidden");
        this.manager.read(false);
    }
}

