/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.database;

import com.sysranger.common.database.Database;
import com.sysranger.common.database.QueryResult;
import com.sysranger.common.database.SRQuery;
import com.sysranger.common.database.SRQueryQueue;
import com.sysranger.common.srjson.SRJson;
import com.sysranger.common.srjson.SRJsonNode;
import com.sysranger.common.utils.CallResult;
import com.sysranger.common.utils.Debugger;
import com.sysranger.common.utils.JsonUtils;
import com.sysranger.common.utils.SRCloser;
import com.sysranger.common.utils.SRFileLogger;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

public class DBGeneric
extends Database {
    private String className = "";
    private String user;
    private String password;
    private String host;
    private int port;
    Properties props = new Properties();
    public String connectionName = "";
    private volatile boolean connecting = false;
    public volatile boolean authError = false;
    private SRQueryQueue queue;

    public DBGeneric(String string) {
        this.connectionName = string;
    }

    public DBGeneric(String string, String string2, int n, String string3, String string4, String string5) {
        this.init(string, string2, n, string3, string4, string5);
    }

    public void init(String string, String string2, int n, String string3, String string4, String string5) {
        this.type = string;
        this.name = string3;
        this.user = string4;
        this.password = string5;
        this.host = string2;
        this.port = n;
        this.props.put("user", string4);
        this.props.put("password", string5);
        this.readOnly = true;
        switch (string) {
            case "mysql": {
                this.connectionString = "jdbc:mysql://" + string2 + ":" + n + "/" + string3;
                this.className = "com.mysql.cj.jdbc.Driver";
                break;
            }
            case "sqlite": {
                this.connectionString = "jdbc:sqlite:" + this.name;
                this.className = "org.sqlite.JDBC";
                this.props.clear();
                break;
            }
            case "syb": {
                this.connectionString = "jdbc:sybase:Tds:" + string2 + ":" + n + "/" + string3;
                this.className = "com.sybase.jdbc4.jdbc.SybDriver";
                this.props.put("ENCRYPT_PASSWORD", "true");
                break;
            }
            case "hdb": {
                this.connectionString = "jdbc:sap://" + string2 + ":" + n;
                this.className = "com.sap.db.jdbc.Driver";
                this.props.put("nonBlockingIO", "false");
                break;
            }
            case "ora": {
                this.connectionString = "jdbc:oracle:thin:@//" + string2 + ":" + n + "/" + string3;
                this.className = "oracle.jdbc.OracleDriver";
                break;
            }
            case "mss": {
                this.connectionString = "jdbc:sqlserver://" + string2 + ":" + n + ";databaseName=" + string3 + ";encrypt=true;trustServerCertificate=true;";
                this.className = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            }
        }
    }

    @Override
    public void startQueue() {
        this.queue = new SRQueryQueue(this);
        this.queue.start();
    }

    public void init() {
        this.init(this.type, this.host, this.port, this.name, this.user, this.password);
    }

    public void updateInfo(String string, String string2, int n) {
        if (!string.equals(this.user)) {
            this.props.put("user", string);
        }
        if (!string2.equals(this.password)) {
            this.props.put("password", string2);
        }
        this.user = string;
        this.password = string2;
        this.port = n;
    }

    @Override
    public void disconnect() {
        this.connected = false;
    }

    @Override
    public CallResult connect() {
        this.connected = false;
        this.connecting = true;
        this.log("Connecting...");
        if (this.user.isBlank() || this.password.isBlank()) {
            this.authError = true;
            return this.error("Connect.Credentials are not set", null);
        }
        try {
            Class.forName(this.className);
            this.conn = DriverManager.getConnection(this.connectionString, this.props);
            if (this.conn == null) {
                Debugger.print("Cannot connect to database:" + this.name);
                return this.error("Cannot connect to database Host:" + this.host + "/" + this.port + " DB:" + this.name, null);
            }
            if (this.type.equals("hdb")) {
                this.conn.setClientInfo("APPLICATION", "SysRanger");
            }
            if (this.readOnly) {
                this.conn.setReadOnly(true);
            }
            this.connected = true;
            this.connecting = false;
            this.connectionError = "";
            this.authError = false;
            this.log("Connected");
            Debugger.print("Connected Database:" + this.name);
            return CallResult.success();
        }
        catch (Exception exception) {
            String string = exception.getClass().getName();
            if (string.equals("com.sap.db.jdbc.exceptions.SQLInvalidAuthorizationSpecExceptionSapDB") || string.contains("Authorization") || string.equals("com.sap.db.jdbc.exceptions.JDBCDriverException") && exception.getMessage().contains("[414]")) {
                this.authError = true;
            }
            this.close();
            return this.error("Connect.Exception.Cannot connect to database", exception);
        }
    }

    public String logFileName() {
        return "dbconnector_" + this.host + "_" + this.type + "_" + this.name;
    }

    private CallResult error(String string, Exception exception) {
        this.connected = false;
        this.connecting = false;
        Object object = string;
        if (exception != null) {
            object = (String)object + " " + exception.getMessage();
        }
        this.connectionError = object;
        SRFileLogger.logDaily(this.logFileName(), "ERROR " + this.type + " - " + this.name + " - " + this.user + " -- " + (String)object);
        return CallResult.error(string, exception);
    }

    public void log(String string) {
        SRFileLogger.logDaily(this.logFileName(), this.type + " - " + this.name + " - " + this.user + " -- " + string);
    }

    public CallResult checkConnection() {
        if (this.connecting) {
            return CallResult.error("Connecting...");
        }
        if (this.conn == null || !this.connected) {
            if (this.authError) {
                return this.error("Connector.Authentication error", null);
            }
            CallResult callResult = this.connect();
            if (callResult.error) {
                return callResult;
            }
        }
        try {
            if (!this.conn.isValid(0)) {
                return this.error("Database connection is not valid", null);
            }
        }
        catch (Exception exception) {
            return this.error("Database connection is not valid", exception);
        }
        try {
            this.conn.getCatalog();
        }
        catch (Exception exception) {
            return this.error(exception.getMessage(), exception);
        }
        return CallResult.success("Healthy");
    }

    public CallResult healthy() {
        if (!this.connected) {
            return CallResult.error(this.connectionError);
        }
        return CallResult.success();
    }

    @Override
    public String getAllTables() {
        SRJson sRJson = new SRJson();
        SRJsonNode sRJsonNode = sRJson.addArray("tables");
        try {
            DatabaseMetaData databaseMetaData = this.conn.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, null);
            while (resultSet.next()) {
                SRJsonNode sRJsonNode2 = new SRJsonNode("table");
                String string = resultSet.getString("Table_NAME");
                sRJsonNode2.add("n", string);
                sRJsonNode.addToArray(sRJsonNode2);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return JsonUtils.error("Error while getting database list");
        }
        return sRJson.toString();
    }

    @Override
    public QueryResult execute(String string, Object ... objectArray) {
        QueryResult queryResult = new QueryResult();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(string);
            block14: for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                String string2 = "String";
                if (object != null) {
                    string2 = object.getClass().getSimpleName();
                } else {
                    object = "";
                }
                switch (string2) {
                    case "String": {
                        preparedStatement.setString(i + 1, String.valueOf(object));
                        continue block14;
                    }
                    case "Byte": {
                        preparedStatement.setByte(i + 1, (Byte)object);
                        continue block14;
                    }
                    case "Integer": {
                        preparedStatement.setInt(i + 1, (Integer)object);
                        continue block14;
                    }
                    case "Long": {
                        preparedStatement.setLong(i + 1, (Long)object);
                        continue block14;
                    }
                    default: {
                        preparedStatement.setString(i + 1, String.valueOf(object));
                    }
                }
            }
            preparedStatement.executeUpdate();
            preparedStatement.close();
            queryResult.error = false;
        }
        catch (Exception exception) {
            queryResult.error = true;
            queryResult.errorMessage = exception.getMessage();
            queryResult.exception = exception;
            SRCloser.close(preparedStatement);
            Debugger.debug(exception.getMessage() + " " + string);
        }
        return queryResult;
    }

    @Override
    public QueryResult executeStructuralQuery(String string) {
        return new QueryResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesExist(String string, Object ... objectArray) {
        QueryResult queryResult = this.select(string, objectArray);
        if (queryResult.error) {
            return false;
        }
        try {
            boolean bl = queryResult.rst.next();
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            queryResult.close();
        }
        return false;
    }

    @Override
    public QueryResult select(String string, Object ... objectArray) {
        QueryResult queryResult = new QueryResult();
        queryResult.query = string;
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement(string);
            queryResult.statement = preparedStatement;
            int n = preparedStatement.getParameterMetaData().getParameterCount();
            if (objectArray != null) {
                block14: for (int i = 0; i < objectArray.length; ++i) {
                    String string2;
                    if (i >= n) {
                        Debugger.print("I>Paramcount");
                    }
                    Object object = objectArray[i];
                    switch (string2 = object.getClass().getSimpleName()) {
                        case "String": {
                            preparedStatement.setString(i + 1, String.valueOf(object));
                            continue block14;
                        }
                        case "Byte": {
                            preparedStatement.setByte(i + 1, (Byte)object);
                            continue block14;
                        }
                        case "Integer": {
                            preparedStatement.setInt(i + 1, (Integer)object);
                            continue block14;
                        }
                        case "Long": {
                            preparedStatement.setLong(i + 1, (Long)object);
                            continue block14;
                        }
                        default: {
                            preparedStatement.setString(i + 1, String.valueOf(object));
                        }
                    }
                }
            }
            queryResult.rst = preparedStatement.executeQuery();
            queryResult.error = false;
            this.results.add(queryResult);
            return queryResult;
        }
        catch (SQLException sQLException) {
            queryResult.errorMessage = "SQLError:" + sQLException.getMessage();
            queryResult.close();
            queryResult.error = true;
            return queryResult;
        }
    }

    @Override
    public String selectAsJSON(String string, Object ... objectArray) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long selectID(String string, Object ... objectArray) {
        try (QueryResult queryResult = null;){
            long l;
            queryResult = this.select(string, objectArray);
            if (queryResult.error) {
                long l2 = 0L;
                return l2;
            }
            boolean bl = queryResult.rst.next();
            if (!bl) {
                long l3 = 0L;
                return l3;
            }
            long l4 = l = queryResult.rst.getLong(1);
            return l4;
        }
        return 0L;
    }

    @Override
    public DBGeneric setConnectionError(String string) {
        this.connected = false;
        this.connectionError = string;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFirstString(String string, Object ... objectArray) {
        QueryResult queryResult = this.select(string, objectArray);
        if (queryResult.error) {
            return "";
        }
        try {
            queryResult.rst.next();
            String string2 = queryResult.rst.getString(1);
            if (string2 == null) {
                String string3 = "";
                return string3;
            }
            String string4 = string2;
            return string4;
        }
        catch (SQLException sQLException) {
            Debugger.debug(sQLException);
        }
        finally {
            if (queryResult != null) {
                queryResult.close();
            }
        }
        return "";
    }

    @Override
    public String safeTableName(String string) {
        try {
            DatabaseMetaData databaseMetaData = this.conn.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, null);
            while (resultSet.next()) {
                String string2 = resultSet.getString("Table_NAME");
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    @Override
    public void queue(SRQuery sRQuery) {
        if (this.queue == null) {
            Debugger.error(this.name + " Queue is not started");
            return;
        }
        this.queue.add(sRQuery);
    }

    @Override
    public void queueAll(List<SRQuery> list) {
        if (this.queue == null) {
            Debugger.error(this.name + " Queue is not started");
            return;
        }
        this.queue.addAll(list);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }
}

