/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.database;

import com.sysranger.common.database.Database;
import com.sysranger.common.database.QueryResult;
import com.sysranger.common.database.SRQuery;
import com.sysranger.common.utils.Debugger;
import com.sysranger.common.utils.Utils;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SRQueryQueue
extends Thread {
    private Database db;
    private ConcurrentLinkedQueue<SRQuery> queries = new ConcurrentLinkedQueue();
    private long wait = 5000L;
    private volatile boolean exit = false;

    public SRQueryQueue(Database database) {
        super("SysRanger-SRQueryQueue - " + database.name);
        this.db = database;
    }

    public void add(SRQuery sRQuery) {
        this.queries.add(sRQuery);
    }

    public void addAll(List<SRQuery> list) {
        this.queries.addAll(list);
    }

    public void setWait(long l) {
        this.wait = l;
    }

    private void executeQueries() {
        SRQuery sRQuery = this.queries.poll();
        while (sRQuery != null) {
            QueryResult queryResult = this.db.execute(sRQuery.query, sRQuery.values);
            if (sRQuery.debug) {
                Debugger.info(sRQuery.query);
                if (queryResult.error) {
                    Debugger.debug(this.db.name + " - " + queryResult.errorMessage);
                }
            }
            sRQuery = this.queries.poll();
        }
    }

    @Override
    public void run() {
        while (!this.exit) {
            Utils.sleep(this.wait);
            try {
                this.executeQueries();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void dispose() {
        this.exit = true;
    }
}

