/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.mailsender;

import com.sysranger.common.database.Database;
import com.sysranger.common.database.QueryResult;
import com.sysranger.common.database.SRQuery;
import com.sysranger.common.notification.SRSMSSender;
import com.sysranger.common.utils.Debugger;
import com.sysranger.common.utils.Time;
import com.sysranger.common.utils.Utils;
import com.sysranger.mailsender.MailHandler;
import com.sysranger.mailsender.MailSender;
import com.sysranger.mailsender.SMTPHandler;
import com.sysranger.mailsender.SRMail;

public class MailChecker
extends Thread {
    private MailSender manager;
    private volatile boolean exit = false;
    private Database database;
    private Time timeLogClear = new Time();
    private final long READ_START = 18000000L;
    private final int DELAY = 5000;
    private long handled = 0L;
    private long timeErrorInformed = 0L;

    public MailChecker(MailSender mailSender) {
        this.setName("SysRangerMailSender-MailChecker");
        this.manager = mailSender;
        this.database = this.manager.database;
        this.start();
    }

    public MailSender manager() {
        return this.manager;
    }

    @Override
    public void run() {
        Debugger.print("Starting Mail Checker");
        Utils.sleep(1000L);
        while (!this.exit) {
            Utils.sleep(1000L);
            if (this.timeLogClear.elapsed(86400000L)) {
                this.clearLogs();
            }
            try {
                boolean bl;
                boolean bl2 = this.send();
                if (bl2) {
                    Thread.sleep(5000L);
                }
                if (!(bl = this.retry())) continue;
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private boolean send() {
        long l = System.currentTimeMillis();
        long l2 = l - 18000000L;
        String string = this.handled % 2L == 0L ? "desc" : "";
        String string2 = "select id,created,m_from,m_to,subject,body,try,lasttry,attachmentname,attachmentfile,extension,status from sr_mails  where created>? and status in(0)  order by id " + string + " limit 1";
        QueryResult queryResult = this.database.select(string2, l2);
        if (queryResult.error) {
            return Debugger.error(queryResult.errorMessage);
        }
        boolean bl = queryResult.next();
        if (!bl) {
            return false;
        }
        SRMail sRMail = SRMail.fromDB(queryResult);
        if (sRMail.id < 1L) {
            return Debugger.error("Cannot read data from database table sr_mails " + sRMail.readError);
        }
        queryResult.close();
        sRMail.status = 1;
        this.handle(sRMail);
        ++this.handled;
        return true;
    }

    private boolean retry() {
        long l = System.currentTimeMillis();
        long l2 = l - 18000000L;
        String string = "select id,created,m_from,m_to,subject,body,try,lasttry,attachmentname,attachmentfile,extension,error,status from sr_mails  where created>" + l2 + " and status in(10)  and lasttry<" + l + "-(try*300000) order by lasttry limit 1";
        QueryResult queryResult = this.database.select(string, new Object[0]);
        if (queryResult.error) {
            return Debugger.error(queryResult.errorMessage);
        }
        boolean bl = queryResult.next();
        if (!bl) {
            return false;
        }
        SRMail sRMail = SRMail.fromDB(queryResult);
        if (sRMail.id < 1L) {
            return Debugger.error("Cannot read data from database table sr_mails " + sRMail.readError);
        }
        queryResult.close();
        this.handle(sRMail);
        String string2 = "Mail sending is not successfull to:" + sRMail.to;
        this.alert(string2);
        return true;
    }

    private void handle(SRMail sRMail) {
        ++sRMail.tries;
        sRMail.lastTry = System.currentTimeMillis();
        String string = "update sr_sms set status=?,lasttry=?,try=?,reset=0 where id=?";
        QueryResult queryResult = this.database.execute(string, sRMail.status, sRMail.lastTry, sRMail.tries, sRMail.id);
        if (queryResult.error) {
            Debugger.error("Database Error:" + queryResult.errorMessage);
        }
        new MailHandler(this, sRMail);
    }

    private void alert(String string) {
        long l = System.currentTimeMillis();
        if (this.timeErrorInformed > l - 0x6DDD00L) {
            return;
        }
        this.timeErrorInformed = l;
        this.alertMail(string);
        this.alertSMS(string);
    }

    private void alertMail(String string) {
        try {
            SMTPHandler sMTPHandler = new SMTPHandler();
            SRMail sRMail = new SRMail();
            sRMail.to = "emre.ozoglu@gmail.com,emre.ozoglu@orkosoft.com,ahmet.karaca@orkosoft.com,mehmet.kalyoncu@orkosoft.com,akaracadan@gmail.com";
            sRMail.subject = "Mail System Error";
            sRMail.body = "There is an error on sending email Check it immediately. Error:" + string;
            sMTPHandler.send(sRMail);
        }
        catch (Exception exception) {
            Debugger.error("Error while sending alert mail:" + exception.getMessage());
        }
    }

    private void alertSMS(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"5352214058"}) {
            SRSMSSender sRSMSSender = new SRSMSSender();
            sRSMSSender.number = string2;
            sRSMSSender.message = string;
            sRSMSSender.send();
        }
    }

    private void clearLogs() {
        long l = System.currentTimeMillis() - 7776000000L;
        String string = "delete from sr_mail_log where tm<?";
        SRQuery sRQuery = new SRQuery(string, l);
        this.database.queue(sRQuery);
    }

    public void dispose() {
        this.exit = true;
    }
}

