/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.mailsender;

import com.sysranger.common.database.SRQuery;
import com.sysranger.common.utils.CallResult;
import com.sysranger.common.utils.Debugger;
import com.sysranger.common.utils.Utils;
import com.sysranger.mailsender.MailChecker;
import com.sysranger.mailsender.SMTPHandler;
import com.sysranger.mailsender.SRMail;

public class MailHandler
extends Thread {
    private SRMail mail;
    public volatile boolean exited = false;
    public volatile long created = 0L;
    private MailChecker checker;
    private int connectionTimeout = 10000;
    private int readTimeout = 30000;

    public MailHandler(MailChecker mailChecker, SRMail sRMail) {
        this.mail = sRMail;
        this.checker = mailChecker;
        this.created = System.currentTimeMillis();
        this.setName("MailHandler-" + sRMail.id);
        this.start();
    }

    @Override
    public void run() {
        Utils.sleep(1000L);
        Debugger.print("Handling " + this.mail.toString());
        CallResult callResult = this.send();
        if (!callResult.error) {
            this.mail.status = (byte)99;
            this.mail.sent = System.currentTimeMillis();
        } else {
            this.mail.status = (byte)10;
            this.mail.error = callResult.message;
        }
        this.save(this.mail);
        this.exited = true;
    }

    private CallResult send() {
        SMTPHandler sMTPHandler = new SMTPHandler();
        return sMTPHandler.send(this.mail);
    }

    private void save(SRMail sRMail) {
        String string = "update sr_mails set status=?, error=?,sent=? where id=" + sRMail.id;
        SRQuery sRQuery = new SRQuery(string, sRMail.status, sRMail.error, sRMail.sent);
        this.checker.manager().database.queue(sRQuery);
        if (sRMail.status == 10 || sRMail.status == 20) {
            Debugger.error(sRMail.toString() + " >> " + sRMail.error);
        } else {
            Debugger.print("Complete:" + sRMail.toString());
        }
    }
}

