/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.mailsender;

import com.sysranger.common.app.SRApp;
import com.sysranger.common.app.Ticker;
import com.sysranger.common.database.DBGeneric;
import com.sysranger.common.database.Database;
import com.sysranger.common.database.DatabaseKeepAlive;
import com.sysranger.common.utils.CallResult;
import com.sysranger.common.utils.Debugger;
import com.sysranger.mailsender.MailChecker;
import java.util.Arrays;

public class MailSender
extends SRApp {
    private static SRApp app;
    public String version = "0.01";
    private MailChecker checker;
    public Database database;

    public MailSender(String[] stringArray) {
        this.setUncaughtExceptionHandler();
        this.name = "SysRangerMailSender";
    }

    public static void serviceStart(String[] stringArray) {
        Debugger.log("Start Service[SysRangerMailSender]:" + Arrays.toString(stringArray));
        try {
            if (app != null) {
                app.stop();
            }
            app = new MailSender(stringArray);
            app.init();
        }
        catch (Exception exception) {
            Debugger.error("Service starting Error: " + exception.getMessage());
        }
    }

    public static void serviceStop(String[] stringArray) {
        Debugger.log("Stop Service[SysRangerMailSender]:" + Arrays.toString(stringArray));
        if (app != null) {
            app.stop();
            app = null;
        }
    }

    @Override
    public void init() {
        Debugger.print("SysRangerMailSender[" + this.version + "] started");
        Debugger.init(this);
        this.start();
    }

    @Override
    public void start() {
        System.out.println("Starting SysRanger MailSender " + this.version + "...");
        this.database = new DBGeneric("mysql", "localhost", 3306, "sysranger", "sysranger", "ZV//d8)*pM3Bc1EJ6a4uK");
        this.database.readOnly = false;
        CallResult callResult = this.database.connect();
        if (callResult.error) {
            Debugger.error(callResult.message + " " + callResult.exception);
            return;
        }
        this.database.startQueue();
        new DatabaseKeepAlive(this.database);
        this.checker = new MailChecker(this);
        new Ticker(this);
    }

    @Override
    public void tick() {
        this.database.tick();
    }

    @Override
    public void stop() {
        try {
            if (this.checker != null) {
                this.checker.dispose();
            }
            if (this.database != null) {
                this.database.close();
            }
            Debugger.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private void setUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                System.err.println("Unhandled Exception:" + throwable.getMessage() + " Thread:" + thread.toString());
                throwable.printStackTrace();
            }
        });
    }

    public static void main(String[] stringArray) {
        MailSender mailSender = new MailSender(stringArray);
        mailSender.init();
    }
}

