/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.database;

import com.sysranger.common.database.Database;
import com.sysranger.common.database.QueryResult;
import com.sysranger.common.utils.Debugger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class LogDBUpdater {
    private Database db;
    private HashMap<String, String> tables = new HashMap();
    private DatabaseMetaData meta;

    public LogDBUpdater(Database database) {
        this.db = database;
        this.update();
    }

    public boolean update() {
        try {
            this.meta = this.db.conn.getMetaData();
            boolean bl = this.createTables();
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean createTables() throws Exception {
        this.tables.put("srl_logs", "CREATE TABLE IF NOT EXISTS srl_logs ( id integer PRIMARY KEY, tm integer default 0, type integer default 0,  msg TEXT default NULL);");
        this.tables.put("srl_signal", "CREATE TABLE IF NOT EXISTS srl_signal ( tm integer default 0,  status TEXT default NULL,  info TEXT default NULL);");
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        ResultSet resultSet = this.meta.getTables(null, null, null, null);
        while (resultSet.next()) {
            String string = resultSet.getString("Table_NAME");
            hashMap.put(string, true);
        }
        for (Map.Entry entry : this.tables.entrySet()) {
            String string = (String)entry.getKey();
            if (hashMap.containsKey(string)) continue;
            String string2 = (String)entry.getValue();
            boolean bl = this.db.executeStructuralQuery(string2);
            if (!bl) {
                return false;
            }
            Debugger.print("Stats Table Created:" + string);
        }
        try {
            this.updateColumns();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.init();
    }

    private boolean init() {
        String string = "select tm from srl_signal";
        long l = this.db.selectID(string, new Object[0]);
        if (l < 1L) {
            string = "insert into srl_signal(tm,status,info) values(100,'','');";
            QueryResult queryResult = this.db.execute(string, new Object[0]);
            if (queryResult.error) {
                System.err.println("LOG DB Error:" + queryResult.errorMessage);
                return false;
            }
        }
        return true;
    }

    private boolean updateColumns() throws Exception {
        return true;
    }
}

