/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.srjson;

import com.sysranger.common.srjson.SRJsonNode;
import java.util.HashMap;
import java.util.Map;

public class SRJson {
    private HashMap<String, SRJsonNode> nodes = new HashMap();

    public SRJsonNode add(SRJsonNode sRJsonNode) {
        this.nodes.put(sRJsonNode.name, sRJsonNode);
        return sRJsonNode;
    }

    public SRJsonNode add(String string) {
        SRJsonNode sRJsonNode = new SRJsonNode(string);
        this.nodes.put(string, sRJsonNode);
        return sRJsonNode;
    }

    public SRJsonNode add(String string, Object object) {
        SRJsonNode sRJsonNode = new SRJsonNode(string, object);
        this.nodes.put(string, sRJsonNode);
        return sRJsonNode;
    }

    public SRJsonNode addArray(String string) {
        SRJsonNode sRJsonNode = new SRJsonNode(string);
        sRJsonNode.asArray();
        this.add(sRJsonNode);
        return sRJsonNode;
    }

    public String getString(String string) {
        SRJsonNode sRJsonNode = this.nodes.get(string);
        if (sRJsonNode == null) {
            return "";
        }
        return (String)sRJsonNode.value;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        SRJsonNode sRJsonNode = this.nodes.get("success");
        if (sRJsonNode != null) {
            stringBuilder.append("{\"success\":").append(sRJsonNode.value.toString()).append(",");
        } else {
            stringBuilder.append("{\"success\":true,");
        }
        for (Map.Entry<String, SRJsonNode> entry : this.nodes.entrySet()) {
            SRJsonNode sRJsonNode2 = entry.getValue();
            String string = sRJsonNode2.toString();
            stringBuilder.append("\"").append(entry.getKey()).append("\":").append(string);
            stringBuilder.append(",");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static SRJson error(String string) {
        SRJson sRJson = new SRJson();
        sRJson.add("success", false);
        sRJson.add("error", string);
        return sRJson;
    }

    public static SRJson error(String string, Object ... objectArray) {
        SRJson sRJson = new SRJson();
        sRJson.add("success", false);
        sRJson.add("error", string);
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i + 1];
            String string2 = (String)objectArray[i];
            sRJson.add(string2, object);
        }
        return sRJson;
    }

    public HashMap<String, SRJsonNode> getNodes() {
        return this.nodes;
    }

    public static String empty() {
        return "{}";
    }

    public static String success() {
        return "{\"success\":true}";
    }

    public static String success(String string) {
        SRJson sRJson = new SRJson();
        if (string != null && !string.isEmpty()) {
            sRJson.add("message", string);
        }
        return sRJson.toString();
    }

    public SRJson merge(SRJson sRJson) {
        for (Map.Entry<String, SRJsonNode> entry : sRJson.getNodes().entrySet()) {
            SRJsonNode sRJsonNode = entry.getValue();
            this.add(sRJsonNode);
        }
        return this;
    }

    public SRJson merge(String string, SRJson sRJson) {
        SRJsonNode sRJsonNode = this.add(string);
        for (Map.Entry<String, SRJsonNode> entry : sRJson.getNodes().entrySet()) {
            SRJsonNode sRJsonNode2 = entry.getValue();
            sRJsonNode.add(sRJsonNode2);
        }
        return this;
    }
}

