/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.utils;

import com.sysranger.common.app.SRApp;
import com.sysranger.common.database.DatabaseSQLite;
import com.sysranger.common.database.LogDBUpdater;
import com.sysranger.common.database.SRLogEntry;
import com.sysranger.common.database.SRQuery;
import com.sysranger.common.utils.CallResult;
import com.sysranger.common.utils.Debugger;
import com.sysranger.common.utils.Time;
import com.sysranger.common.utils.Utils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SRLogger
extends Thread {
    SimpleDateFormat df;
    private ConcurrentLinkedQueue<SRLogEntry> errors = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<SRLogEntry> infos = new ConcurrentLinkedQueue();
    private DatabaseSQLite db;
    private long tick = 0L;
    private SRApp app;

    public SRLogger(SRApp sRApp) {
        super("SRLogger");
        this.app = sRApp;
        this.db = new DatabaseSQLite("logs");
        this.db.queue.setWait(2000L);
        CallResult callResult = this.db.connect();
        if (callResult.error) {
            Debugger.error("Cannot connect to log database");
        }
        new LogDBUpdater(this.db);
        String string = "yyyy.MM.dd HH:mm:ss";
        this.df = new SimpleDateFormat(string);
        System.setErr(new PrintStream(System.err){

            @Override
            public void println(String string) {
                super.println(string);
                if (SRLogger.this.errors.size() > 10000) {
                    return;
                }
                SRLogger.this.errors.add(new SRLogEntry(1, System.currentTimeMillis(), string));
            }
        });
        System.setOut(new PrintStream(System.out){

            @Override
            public void println(String string) {
                super.println(string);
                if (SRLogger.this.infos.size() > 10000) {
                    return;
                }
                SRLogger.this.infos.add(new SRLogEntry(0, System.currentTimeMillis(), string));
            }
        });
        this.start();
    }

    @Override
    public void run() {
        Time time = new Time();
        while (true) {
            Utils.sleep(1000L);
            this.writeErrors();
            this.writeInfos();
            if (this.tick % 5L == 0L) {
                this.signal();
            }
            if (time.elaspsed(86400000L)) {
                this.clear();
            }
            ++this.tick;
        }
    }

    public DatabaseSQLite database() {
        return this.db;
    }

    private void signal() {
        long l = System.currentTimeMillis();
        String string = "update srl_signal set tm=?,status=?";
        SRQuery sRQuery = new SRQuery(string, l, this.app.status());
        this.db.queue(sRQuery);
    }

    private void writeErrors() {
        if (this.errors.isEmpty()) {
            return;
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("logs/errors.txt", true));
            while (!this.errors.isEmpty()) {
                SRLogEntry sRLogEntry = this.errors.poll();
                String string = this.df.format(new Date(sRLogEntry.time));
                Object object = sRLogEntry.message;
                object = ((String)object).replaceAll("\n", " ");
                object = string + " " + (String)object;
                bufferedWriter.write((String)object + "\n");
                this.addToDB(sRLogEntry);
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeInfos() {
        if (this.infos.isEmpty()) {
            return;
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("logs/logs.txt", true));
            while (!this.infos.isEmpty()) {
                SRLogEntry sRLogEntry = this.infos.poll();
                String string = this.df.format(new Date(sRLogEntry.time));
                Object object = sRLogEntry.message;
                object = ((String)object).replaceAll("\n", " ");
                object = string + " " + (String)object;
                bufferedWriter.write((String)object + "\n");
                this.addToDB(sRLogEntry);
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addToDB(SRLogEntry sRLogEntry) {
        String string = "insert into srl_logs (tm,type,msg) values (?,?,?)";
        SRQuery sRQuery = new SRQuery(string, sRLogEntry.time, sRLogEntry.type, sRLogEntry.message);
        this.db.queue(sRQuery);
    }

    private void clear() {
        long l = System.currentTimeMillis();
        long l2 = l - 2592000000L;
        SRQuery sRQuery = new SRQuery("delete from srl_logs where tm<" + l2, new Object[0]);
        this.db.queue(sRQuery);
    }

    public void dispose() {
        try {
            System.setOut(null);
            System.setErr(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writeErrors();
        this.writeInfos();
        this.db.close();
    }
}

