/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.utils;

import com.sysranger.common.utils.CallResult;
import com.sysranger.common.utils.Debugger;
import com.sysranger.common.utils.JsonUtils;
import com.sysranger.common.utils.SRCloser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Utils {
    private static String[] BYTE_UNITS = new String[]{"B", "kB", "MB", "GB", "TB"};
    private static final char[] symbols = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final SecureRandom random = new SecureRandom();
    public static final long MS_MINUTE = 60000L;
    public static final long MS_DAY = 86400000L;
    public static final long MS_MINUTE_5 = 300000L;
    public static final long MS_HOUR = 3600000L;
    public static final long MS_MONTH = 2678400000L;

    public static String randomString(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = symbols[random.nextInt(symbols.length)];
        }
        return new String(cArray);
    }

    public static int random(int n, int n2) {
        return n + random.nextInt(n2 - n);
    }

    public static String hash(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] byArray = messageDigest.digest(string.getBytes(StandardCharsets.UTF_8));
            StringBuffer stringBuffer = new StringBuffer();
            for (byte by : byArray) {
                stringBuffer.append(Integer.toString((by & 0xFF) + 256, 16).substring(1));
            }
            return stringBuffer.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return string;
        }
    }

    public static String md5(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(string.getBytes(StandardCharsets.UTF_8));
            return String.format("%032x", new BigInteger(1, byArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static String bytesToUnit(long l) {
        double d;
        int n = 0;
        for (d = (double)l; d > 1024.0 && n < BYTE_UNITS.length - 1; d /= 1024.0, ++n) {
        }
        return String.format("%d %s", Math.round(d), BYTE_UNITS[n]);
    }

    public static String toJSON(String ... stringArray) {
        Object object = "{";
        for (int i = 0; i < stringArray.length; i += 2) {
            object = (String)object + "\"" + stringArray[i] + "\":\"" + stringArray[i + 1] + "\",";
        }
        if (((String)object).length() > 1) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        object = (String)object + "}";
        return object;
    }

    public static String toJSON(Object ... objectArray) {
        Object object = "{";
        for (int i = 0; i < objectArray.length; i += 2) {
            String string;
            Object object2 = objectArray[i + 1];
            Object object3 = "";
            switch (string = object2.getClass().getSimpleName()) {
                case "Integer": 
                case "Long": {
                    object3 = String.valueOf(object2);
                    break;
                }
                case "Boolean": {
                    object3 = (Boolean)object2 != false ? "true" : "false";
                    break;
                }
                default: {
                    object3 = "\"" + String.valueOf(object2) + "\"";
                }
            }
            object = (String)object + "\"" + String.valueOf(objectArray[i]) + "\":" + (String)object3 + ",";
        }
        if (((String)object).length() > 1) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        object = (String)object + "}";
        return object;
    }

    public static String toJSON(Map<String, String> map) {
        Object object = "{";
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            object = (String)object + "\"" + entry.getKey() + "\":\"" + entry.getValue() + "\",";
        }
        if (((String)object).length() > 1) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        object = (String)object + "}";
        return object;
    }

    public static String readFile(File file) {
        String string = "";
        try {
            string = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static CallResult readFile(String string) {
        String string2 = "";
        try {
            File file = new File(string);
            if (!file.exists()) {
                return CallResult.error("File:" + string + " doesn't exist");
            }
            if (!file.canRead()) {
                return CallResult.error("File:" + string + " cannot be read");
            }
            string2 = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
            return CallResult.success(string2);
        }
        catch (Exception exception) {
            return CallResult.error(exception.getMessage());
        }
    }

    public static CallResult writeFile(String string, String string2) {
        try {
            Files.write(Paths.get(string2, new String[0]), string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return CallResult.error(iOException.getMessage());
        }
        return CallResult.success();
    }

    public static String escape(String string) {
        return string.replace("\\", "\\\\").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replace("'", "\\'").replace("\"", "\\\"");
    }

    public static int toIntPositive(String string) {
        try {
            string = string.replaceAll("[^\\d]", "");
            int n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int toInt(String string) {
        try {
            string = string.replaceAll("[^\\d-]", "");
            int n = Integer.parseInt(string);
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int toInt(Object object) {
        if (object == null) {
            return 0;
        }
        return Utils.toInt(object.toString());
    }

    public static long toLong(String string) {
        try {
            string = string.replaceAll("[^\\d-]", "");
            long l = Long.parseLong(string);
            return l;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static int toInt(String string, int n) {
        try {
            string = string.replaceAll("[^\\d-]", "");
            int n2 = Integer.parseInt(string);
            return n2;
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static double toDouble(String string) {
        try {
            double d = Double.parseDouble(string);
            return d;
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public static byte toByte(String string) {
        try {
            string = string.replaceAll("[^\\d-]", "");
            byte by = Byte.parseByte(string);
            return by;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static boolean sleep(long l) {
        try {
            Thread.sleep(l);
            return true;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return false;
        }
    }

    public static byte[] concatByteArrays(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static char[] bytesToChar(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)byArray[i];
        }
        return cArray;
    }

    public static boolean arrayContains(byte[] byArray, byte by) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != by) continue;
            return true;
        }
        return false;
    }

    public static byte[] longtoBytes(long l) {
        return new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 0 & 0xFFL)};
    }

    public static boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        return Boolean.parseBoolean(object.toString());
    }

    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static String date() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd - HH:mm:ss.SSS");
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    public static int getSAPPort(String string) {
        return Utils.toInt("5" + string + "13");
    }

    public static String stackTraceToString(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            stringBuilder.append(stackTraceElement.toString() + "\n");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String textFromURL(String string) {
        String string2;
        BufferedReader bufferedReader = null;
        HttpURLConnection httpURLConnection = null;
        try {
            String string3;
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.addRequestProperty("User-Agent", "Mozilla/4.0");
            httpURLConnection.setRequestProperty("Cache-Control", "no-cache");
            httpURLConnection.setRequestProperty("charset", StandardCharsets.UTF_8.name());
            httpURLConnection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
            httpURLConnection.setReadTimeout(50000);
            httpURLConnection.setConnectTimeout(50000);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setAllowUserInteraction(false);
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string3);
            }
            string2 = stringBuilder.toString();
        }
        catch (Exception exception) {
            try {
                Debugger.error("Cannot reach url:" + string + " " + exception.getMessage());
            }
            catch (Throwable throwable) {
                SRCloser.close(bufferedReader);
                SRCloser.close(httpURLConnection);
                throw throwable;
            }
            SRCloser.close(bufferedReader);
            SRCloser.close(httpURLConnection);
            return "";
        }
        SRCloser.close(bufferedReader);
        SRCloser.close(httpURLConnection);
        return string2;
    }

    protected static String post(String string, HashMap<String, String> hashMap) {
        hashMap.put("rnd", "" + System.currentTimeMillis());
        try {
            String string2 = Utils.getFormDataAsString(hashMap);
            HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofString(string2);
            Debugger.print("Utils.post:" + string + " > " + string2);
            HttpClient httpClient = HttpClient.newHttpClient();
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string)).header("Content-Type", "application/x-www-form-urlencoded").header("Cache-Control", "private, no-store, no-cache, must-revalidate").header("Pragma", "no-cache").POST(bodyPublisher).build();
            HttpResponse<String> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            return httpResponse.body();
        }
        catch (Exception exception) {
            return JsonUtils.error(exception.getMessage());
        }
    }

    public static String getFormDataAsString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8));
            stringBuilder.append("=");
            stringBuilder.append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
        }
        return stringBuilder.toString();
    }

    public static boolean createFolderIfNotExist(String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                return true;
            }
            return file.mkdirs();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name", "generic");
        string = string.toLowerCase(Locale.ENGLISH);
        return string.contains("win");
    }

    public static String getHostAddressOfBytes(byte[] byArray) {
        try {
            InetAddress inetAddress = InetAddress.getByAddress(byArray);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
    }

    public static String trim(String string, int n) {
        if (string == null) {
            return "";
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, n);
    }

    public static <T> String join(CharSequence charSequence, Iterable<T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        CharSequence charSequence2 = "";
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            stringBuilder.append(charSequence2);
            stringBuilder.append(string);
            charSequence2 = charSequence;
        }
        return stringBuilder.toString();
    }

    public static long timeStamp() {
        return new Date().getTime();
    }

    public static boolean isValidEnglish(String string) {
        char[] cArray = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            for (int j = 0; j < cArray.length; ++j) {
                if (c != cArray[j]) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }
}

