/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.logviewer;

import com.sysranger.common.database.SRLogEntry;
import com.sysranger.logviewer.FrameBase;
import com.sysranger.logviewer.GUI;
import com.sysranger.logviewer.LogViewer;
import com.sysranger.logviewer.TrayManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.net.URL;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;

public class GUIMain
extends JFrame
implements Runnable,
FrameBase {
    private static final long serialVersionUID = -6485524040272091516L;
    private JTextArea txtDebugger;
    private JTextArea txtError;
    private JPanel panel;
    private LogViewer manager;
    private ConcurrentLinkedQueue<SRLogEntry> logs = new ConcurrentLinkedQueue();
    private JLabel labelStatus;
    private JScrollPane scroll;
    private JScrollPane scrollError;

    public GUIMain(LogViewer logViewer) {
        super(logViewer.name);
        this.manager = logViewer;
        System.out.println("Creating GUI");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.out.println("GUI-Unable to set LookAndFeel");
        }
        this.panel = new JPanel(new BorderLayout());
        this.creteComponents();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("www/images/tray.png"));
        new TrayManager(this);
        this.add((Component)this.panel, "Center");
        this.setVisible(true);
        this.setSize(700, 500);
        Thread thread = new Thread(this);
        thread.setName("GUIMain");
        thread.start();
    }

    public LogViewer getManager() {
        return this.manager;
    }

    private void creteComponents() {
        this.txtDebugger = new JTextArea("");
        this.txtError = new JTextArea("");
        this.txtDebugger.setFont(this.txtDebugger.getFont().deriveFont(12.0f));
        this.txtError.setFont(this.txtError.getFont().deriveFont(12.0f));
        this.txtError.setForeground(Color.RED);
        this.scroll = new JScrollPane(this.txtDebugger, 22, 32);
        this.scrollError = new JScrollPane(this.txtError, 22, 32);
        DefaultCaret defaultCaret = (DefaultCaret)this.txtDebugger.getCaret();
        defaultCaret.setUpdatePolicy(2);
        ((DefaultCaret)this.txtError.getCaret()).setUpdatePolicy(2);
        JSplitPane jSplitPane = new JSplitPane(0, this.scroll, this.scrollError);
        jSplitPane.setResizeWeight(0.6);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        gridBagConstraints.weightx = 1.0;
        jPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.panel.add((Component)jPanel, "North");
        this.panel.add((Component)jSplitPane, "Center");
        this.labelStatus = new JLabel("Status");
        this.labelStatus.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.panel.add((Component)this.labelStatus, "South");
    }

    private void addComponent(JPanel jPanel, GridBagConstraints gridBagConstraints, Component component, int n, int n2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.insets.right = n > 4 ? 0 : 2;
        jPanel.add(component, gridBagConstraints);
    }

    private void print(String string) {
        this.txtDebugger.append(string + "\n");
        if (this.txtDebugger.getText().length() > 10000) {
            this.txtDebugger.setText(this.txtDebugger.getText().substring(8000));
        }
        System.out.println(string);
    }

    private boolean error(String string) {
        this.txtError.append(string + "\n");
        if (this.txtError.getText().length() > 10000) {
            this.txtError.setText(this.txtError.getText().substring(8000));
        }
        System.err.println(string);
        return true;
    }

    @Override
    public void log(SRLogEntry sRLogEntry) {
        this.logs.add(sRLogEntry);
    }

    @Override
    public void status(String string, boolean bl) {
        if (bl) {
            this.labelStatus.setForeground(new Color(36864));
        } else {
            this.labelStatus.setForeground(Color.RED);
        }
        this.labelStatus.setText(string);
    }

    private boolean openBrowser() {
        String string = "http://localhost:8100";
        if (!Desktop.isDesktopSupported()) {
            return this.error("Desktop is not supported");
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URL(string).toURI());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private void consume() {
        while (!this.logs.isEmpty()) {
            SRLogEntry sRLogEntry = this.logs.poll();
            if (sRLogEntry.type == 1) {
                this.error(sRLogEntry.message);
                continue;
            }
            this.print(sRLogEntry.message);
        }
        if (!this.txtDebugger.hasFocus()) {
            this.txtDebugger.setCaretPosition(this.txtDebugger.getDocument().getLength());
        }
        if (!this.txtError.hasFocus()) {
            this.txtError.setCaretPosition(this.txtError.getDocument().getLength());
        }
    }

    @Override
    public void run() {
        this.consume();
        while (true) {
            GUI.sleep(500L);
            this.consume();
            this.repaint();
        }
    }
}

