/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.logviewer;

import com.sysranger.common.database.DatabaseSQLite;
import com.sysranger.common.database.QueryResult;
import com.sysranger.common.database.SRLogEntry;
import com.sysranger.common.utils.Time;
import com.sysranger.logviewer.GUI;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogViewer
extends Thread {
    SimpleDateFormat df;
    SimpleDateFormat dfTime;
    DatabaseSQLite db;
    private long lastLogTime = 0L;
    private volatile boolean read = true;
    private long tick = 0L;
    public String name = "SysRanger Log Viewer";

    public LogViewer(String[] stringArray) {
        super("SysRanger Log Viewer" + (String)(stringArray.length > 0 ? ":" + stringArray[0] : ""));
        this.name = this.name + (String)(stringArray.length > 0 ? ":" + stringArray[0] : "");
        GUI.init(this);
        this.db = new DatabaseSQLite("logs");
        this.db.connect();
        String string = "yyyy.MM.dd HH:mm:ss";
        this.df = new SimpleDateFormat(string);
        this.dfTime = new SimpleDateFormat("HH:mm:ss");
        this.start();
    }

    @Override
    public void run() {
        if (!this.readLogs()) {
            return;
        }
        Time time = new Time();
        while (true) {
            if (this.read) {
                this.readLogs();
                this.readSignal();
            }
            ++this.tick;
            if (this.tick % 10L == 0L) {
                this.db.tick();
            }
            if (time.elaspsed(14400000L)) {
                GUI.log(new SRLogEntry(0, System.currentTimeMillis(), "System.GC"));
                System.gc();
            }
            GUI.sleep(1000L);
        }
    }

    private boolean readLogs() {
        String string = "select * from (select ROWID,tm,type,msg from srl_logs where tm>? and type=0 order by tm desc limit 50) union  select * from (select ROWID,tm,type,msg from srl_logs where tm>? and type=1 order by tm desc limit 50)  order by tm";
        QueryResult queryResult = this.db.select(string, this.lastLogTime, this.lastLogTime);
        if (queryResult.error) {
            queryResult.close();
            return this.error("Cannot read log database:" + queryResult.errorMessage);
        }
        while (queryResult.next()) {
            SRLogEntry sRLogEntry = new SRLogEntry();
            sRLogEntry.type = queryResult.getByte("type");
            sRLogEntry.time = queryResult.getLong("tm");
            sRLogEntry.id = queryResult.getLong("ROWID");
            Object object = queryResult.getString("msg");
            String string2 = this.df.format(new Date(sRLogEntry.time));
            object = ((String)object).replaceAll("\n", " ");
            sRLogEntry.message = object = sRLogEntry.id + " " + string2 + " " + (String)object;
            GUI.log(sRLogEntry);
            this.lastLogTime = sRLogEntry.time;
        }
        queryResult.close();
        return true;
    }

    private boolean error(String string) {
        SRLogEntry sRLogEntry = new SRLogEntry(1, System.currentTimeMillis(), string);
        GUI.log(sRLogEntry);
        GUI.status(sRLogEntry.message, false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readSignal() {
        String string = "select tm,status from srl_signal";
        try (QueryResult queryResult = this.db.select(string, new Object[0]);){
            if (queryResult.error) {
                boolean bl = this.error(queryResult.errorMessage);
                return bl;
            }
            if (queryResult.isEmpty()) {
                boolean bl = this.error("Cannot read signal from the app");
                return bl;
            }
            queryResult.next();
            long l = queryResult.getLong("tm");
            String string2 = queryResult.getString("status");
            long l2 = System.currentTimeMillis();
            if (l < l2 - 10000L) {
                boolean bl = GUI.status("Service is not running", false);
                return bl;
            }
            boolean bl = GUI.status(" Service is running. [" + string2 + "] -----" + this.dfTime.format(new Date(l)), true);
            return bl;
        }
    }

    public void read(boolean bl) {
        this.read = bl;
    }

    public static void main(String[] stringArray) {
        new LogViewer(stringArray);
    }
}

