/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.database;

import com.sysranger.common.database.QueryResult;
import com.sysranger.common.database.SRQuery;
import com.sysranger.common.utils.CallResult;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class Database {
    public static final String HANA = "hdb";
    public static final String ASE = "syb";
    public static final String ORACLE = "ora";
    public static final String DB2 = "db6";
    public static final String MAXDB = "ada";
    public static final String MSSQL = "mss";
    public static final String SQLITE = "sqlite";
    public static final String MYSQL = "mysql";
    public static final long DatabaseStatementClearPeriod = 60000L;
    protected ConcurrentLinkedQueue<QueryResult> results = new ConcurrentLinkedQueue();
    public boolean readOnly = false;
    public Connection conn;
    public String connectionString = "";
    public String name = "";
    protected volatile boolean connected = false;
    public String connectionError = "";
    public String type;

    public static String typeName(String string) {
        switch (string) {
            case "hdb": {
                return "Hana";
            }
            case "syb": {
                return "SyBase";
            }
            case "ora": {
                return "Oracle";
            }
            case "db6": {
                return "DB2";
            }
            case "ada": {
                return "MaxDB";
            }
            case "mss": {
                return "MsSQL";
            }
        }
        return null;
    }

    public static boolean typeAllowed(String string) {
        return Database.typeName(string) != null;
    }

    public abstract CallResult connect();

    public abstract QueryResult execute(String var1, Object ... var2);

    public abstract QueryResult executeStructuralQuery(String var1);

    public abstract boolean doesExist(String var1, Object ... var2);

    public abstract long selectID(String var1, Object ... var2);

    public abstract QueryResult select(String var1, Object ... var2);

    public abstract String selectAsJSON(String var1, Object ... var2);

    public abstract Database setConnectionError(String var1);

    public abstract String getFirstString(String var1, Object ... var2);

    public abstract String safeTableName(String var1);

    public abstract String getAllTables();

    public abstract void queue(SRQuery var1);

    public abstract void queueAll(List<SRQuery> var1);

    public abstract boolean isConnected();

    public abstract void disconnect();

    public abstract void startQueue();

    public void tick() {
        long l = System.currentTimeMillis();
        Iterator<QueryResult> iterator = this.results.iterator();
        while (iterator.hasNext()) {
            QueryResult queryResult = iterator.next();
            if (l - queryResult.time < 60000L) break;
            queryResult.close();
            iterator.remove();
        }
    }

    public void dispose() {
        try {
            Iterator<QueryResult> iterator = this.results.iterator();
            while (iterator.hasNext()) {
                QueryResult queryResult = iterator.next();
                queryResult.close();
                iterator.remove();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean close() {
        this.dispose();
        if (this.conn == null) {
            return false;
        }
        try {
            this.conn.close();
            return true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    public static String escape(String string) {
        string = string.replaceAll("'", "");
        return string;
    }
}

