/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.database;

import com.sysranger.common.database.Database;
import com.sysranger.common.utils.CallResult;
import com.sysranger.common.utils.Debugger;
import com.sysranger.common.utils.SRCloser;
import com.sysranger.common.utils.Utils;
import java.sql.Connection;
import java.sql.Statement;

public class DatabaseKeepAlive
extends Thread {
    private Database db;
    private long keepAliveTime = 120000L;

    public DatabaseKeepAlive(Database database) {
        this.setName("SysRanger-DatabaseKeepAlive - " + database.name);
        this.db = database;
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            Utils.sleep(this.keepAliveTime);
            this.sendTick();
        }
    }

    private void sendTick() {
        String string = Utils.timeStamp() + "_" + Utils.randomString(100);
        String string2 = "update sr_dummy set keepalive='" + string + "'";
        Connection connection = this.db.conn;
        Statement statement = null;
        try {
            if (connection.isClosed()) {
                CallResult callResult = this.db.connect();
                if (callResult.error) {
                    return;
                }
            }
            statement = connection.createStatement();
            statement.executeUpdate(string2);
            Debugger.print("Database KeepAlive:" + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SRCloser.close(statement);
    }
}

