/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.database;

import com.sysranger.common.database.Database;
import com.sysranger.common.database.QueryResult;
import com.sysranger.common.database.SRQuery;
import com.sysranger.common.database.SRQueryQueue;
import com.sysranger.common.srjson.SRJson;
import com.sysranger.common.srjson.SRJsonNode;
import com.sysranger.common.utils.CallResult;
import com.sysranger.common.utils.Debugger;
import com.sysranger.common.utils.JsonUtils;
import com.sysranger.common.utils.SRCloser;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;

public class DatabaseSQLite
extends Database {
    public SRQueryQueue queue;

    public DatabaseSQLite(String string) {
        this.name = string;
        this.connectionString = "jdbc:sqlite:" + this.name;
        this.queue = new SRQueryQueue(this);
    }

    @Override
    public CallResult connect() {
        Debugger.print("Connecting Database:" + this.name);
        try {
            Class.forName("org.sqlite.JDBC");
            this.conn = DriverManager.getConnection(this.connectionString);
            if (this.conn == null) {
                System.err.println("Cannot connect to database");
                return CallResult.error("Cannot connect to database:" + this.name);
            }
            this.queue.start();
            Debugger.print("Connected:" + this.name);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return CallResult.error(exception.getMessage(), exception);
        }
        return CallResult.success();
    }

    @Override
    public QueryResult execute(String string, Object ... objectArray) {
        QueryResult queryResult = new QueryResult();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.conn.prepareStatement(string);
            block14: for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                Object object = objectArray[i];
                String string2 = "String";
                if (object != null) {
                    string2 = object.getClass().getSimpleName();
                } else {
                    object = "";
                }
                switch (string2) {
                    case "String": {
                        preparedStatement.setString(i + 1, String.valueOf(object));
                        continue block14;
                    }
                    case "Byte": {
                        preparedStatement.setByte(i + 1, (Byte)object);
                        continue block14;
                    }
                    case "Integer": {
                        preparedStatement.setInt(i + 1, (Integer)object);
                        continue block14;
                    }
                    case "Long": {
                        preparedStatement.setLong(i + 1, (Long)object);
                        continue block14;
                    }
                    default: {
                        preparedStatement.setString(i + 1, String.valueOf(object));
                    }
                }
            }
            preparedStatement.executeUpdate();
            preparedStatement.close();
            queryResult.error = false;
        }
        catch (Exception exception) {
            queryResult.error = true;
            queryResult.errorMessage = exception.getMessage();
            queryResult.exception = exception;
            SRCloser.close(preparedStatement);
            Debugger.debug(this.name + " - " + exception.getMessage() + " " + string);
        }
        return queryResult;
    }

    public QueryResult selectDirect(String string) {
        QueryResult queryResult = new QueryResult();
        queryResult.query = string;
        try {
            queryResult.statement = this.conn.createStatement();
            queryResult.rst = queryResult.statement.executeQuery(string);
            return queryResult;
        }
        catch (Exception exception) {
            queryResult.errorMessage = exception.getMessage();
            queryResult.error = true;
            return queryResult;
        }
    }

    @Override
    public QueryResult select(String string, Object ... objectArray) {
        QueryResult queryResult = new QueryResult();
        queryResult.query = string;
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement(string);
            queryResult.statement = preparedStatement;
            block14: for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
                String string2;
                Object object = objectArray[i];
                switch (string2 = object.getClass().getSimpleName()) {
                    case "String": {
                        preparedStatement.setString(i + 1, String.valueOf(object));
                        continue block14;
                    }
                    case "Byte": {
                        preparedStatement.setByte(i + 1, (Byte)object);
                        continue block14;
                    }
                    case "Integer": {
                        preparedStatement.setInt(i + 1, (Integer)object);
                        continue block14;
                    }
                    case "Long": {
                        preparedStatement.setLong(i + 1, (Long)object);
                        continue block14;
                    }
                    default: {
                        preparedStatement.setString(i + 1, String.valueOf(object));
                    }
                }
            }
            queryResult.rst = preparedStatement.executeQuery();
            this.results.add(queryResult);
            queryResult.error = false;
            return queryResult;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            queryResult.errorMessage = exception.getMessage();
            System.err.println(queryResult.errorMessage);
            queryResult.close();
            queryResult.error = true;
            return queryResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long selectID(String string, Object ... objectArray) {
        try (QueryResult queryResult = null;){
            long l;
            queryResult = this.select(string, objectArray);
            if (queryResult.error) {
                long l2 = 0L;
                return l2;
            }
            boolean bl = queryResult.rst.next();
            if (!bl) {
                long l3 = 0L;
                return l3;
            }
            long l4 = l = queryResult.rst.getLong(1);
            return l4;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFirstString(String string, Object ... objectArray) {
        QueryResult queryResult = this.select(string, objectArray);
        if (queryResult.error) {
            Debugger.error(queryResult.errorMessage);
            return "";
        }
        try {
            if (queryResult.rst.next()) {
                String string2 = queryResult.rst.getString(1);
                if (string2 == null) {
                    String string3 = "";
                    return string3;
                }
                String string4 = string2;
                return string4;
            }
        }
        catch (Exception exception) {
            Debugger.debug(exception);
        }
        finally {
            if (queryResult != null) {
                queryResult.close();
            }
        }
        return "";
    }

    @Override
    public String selectAsJSON(String string, Object ... objectArray) {
        QueryResult queryResult = this.select(string, objectArray);
        if (queryResult.error) {
            queryResult.close();
            return JsonUtils.error("Database Error:" + queryResult.errorMessage);
        }
        return queryResult.toJSON().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesExist(String string, Object ... objectArray) {
        QueryResult queryResult = this.select(string, objectArray);
        if (queryResult.error) {
            return false;
        }
        try {
            boolean bl = queryResult.rst.next();
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            queryResult.close();
        }
        return false;
    }

    @Override
    public QueryResult executeStructuralQuery(String string) {
        QueryResult queryResult = new QueryResult();
        try {
            Statement statement = this.conn.createStatement();
            statement.execute(string);
            statement.close();
            return queryResult;
        }
        catch (Exception exception) {
            queryResult.error = true;
            queryResult.errorMessage = exception.getMessage();
            return queryResult;
        }
    }

    @Override
    public DatabaseSQLite setConnectionError(String string) {
        this.connected = false;
        this.connectionError = string;
        return this;
    }

    @Override
    public String safeTableName(String string) {
        try {
            DatabaseMetaData databaseMetaData = this.conn.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, null);
            while (resultSet.next()) {
                String string2 = resultSet.getString("Table_NAME");
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    @Override
    public String getAllTables() {
        SRJson sRJson = new SRJson();
        SRJsonNode sRJsonNode = new SRJsonNode("tables");
        sRJson.add(sRJsonNode);
        sRJsonNode.asArray();
        try {
            DatabaseMetaData databaseMetaData = this.conn.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, null);
            while (resultSet.next()) {
                SRJsonNode sRJsonNode2 = new SRJsonNode("table");
                String string = resultSet.getString("Table_NAME");
                sRJsonNode2.add("n", string);
                sRJsonNode.addToArray(sRJsonNode2);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return JsonUtils.error("Error while getting database list");
        }
        return sRJson.toString();
    }

    @Override
    public void queue(SRQuery sRQuery) {
        this.queue.add(sRQuery);
    }

    @Override
    public void queueAll(List<SRQuery> list) {
        this.queue.addAll(list);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void disconnect() {
        this.connected = false;
    }

    @Override
    public void startQueue() {
    }

    @Override
    public boolean close() {
        super.close();
        this.queue.dispose();
        return true;
    }
}

