/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.srjson;

import com.sysranger.common.utils.JsonString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SRJsonNode {
    public String name;
    public Object value;
    public String type;
    public boolean root = false;
    public HashMap<String, SRJsonNode> children = null;
    public ArrayList<SRJsonNode> array = null;
    public boolean leaf = true;
    public boolean error = false;
    public String errorText = null;
    public SRJsonNode parent = null;

    public SRJsonNode(Object object) {
        this.name = object == null ? null : object.toString();
        this.value = object;
    }

    public SRJsonNode(String string, Object object) {
        this.name = string;
        this.value = object;
    }

    public SRJsonNode() {
    }

    public void addMutiple(SRJsonNode ... sRJsonNodeArray) {
        for (int i = 0; i < sRJsonNodeArray.length; ++i) {
            SRJsonNode sRJsonNode = sRJsonNodeArray[i];
            this.add(sRJsonNode);
        }
    }

    public SRJsonNode add(SRJsonNode sRJsonNode) {
        if (this.children == null) {
            this.children = new HashMap();
        }
        this.children.put(sRJsonNode.name, sRJsonNode);
        this.leaf = false;
        sRJsonNode.parent = this;
        return sRJsonNode;
    }

    public SRJsonNode add(String string, Object object) {
        SRJsonNode sRJsonNode = new SRJsonNode(string, object);
        this.add(sRJsonNode);
        return sRJsonNode;
    }

    public SRJsonNode add(String string) {
        SRJsonNode sRJsonNode = new SRJsonNode(string, null);
        this.add(sRJsonNode);
        return sRJsonNode;
    }

    public SRJsonNode addToArray(SRJsonNode sRJsonNode) {
        if (this.array == null) {
            this.array = new ArrayList();
        }
        this.array.add(sRJsonNode);
        this.leaf = false;
        return sRJsonNode;
    }

    public void asArray() {
        this.array = new ArrayList();
        this.leaf = false;
    }

    public SRJsonNode addArray(String string) {
        SRJsonNode sRJsonNode = new SRJsonNode(string);
        sRJsonNode.asArray();
        this.add(sRJsonNode);
        return sRJsonNode;
    }

    public int arraySize() {
        if (this.array == null) {
            return 0;
        }
        return this.array.size();
    }

    public String parseChildren() {
        Object object = "{";
        for (Map.Entry<String, SRJsonNode> entry : this.children.entrySet()) {
            object = (String)object + "\"" + entry.getKey() + "\":" + entry.getValue().toString() + ",";
        }
        if (((String)object).length() > 1) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        object = (String)object + "}";
        return object;
    }

    public SRJsonNode getChild(String string) {
        return this.children.get(string);
    }

    public String parseArray() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (SRJsonNode sRJsonNode : this.array) {
            stringBuilder.append(sRJsonNode.toString()).append(",");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String toString() {
        if (this.leaf) {
            return this.getField(this.value);
        }
        if (this.children != null) {
            return this.parseChildren();
        }
        if (this.array != null) {
            return this.parseArray();
        }
        return null;
    }

    public String getField(Object object) {
        String string;
        Object object2 = "null";
        switch (string = object == null ? "null" : object.getClass().getSimpleName()) {
            case "Byte": 
            case "Integer": 
            case "Double": 
            case "Long": {
                object2 = String.valueOf(object);
                if (!((String)object2).equals("NaN")) break;
                object2 = "0";
                break;
            }
            case "Boolean": {
                object2 = (Boolean)object != false ? "true" : "false";
                break;
            }
            case "JsonString": {
                object2 = ((JsonString)object).text;
                break;
            }
            case "null": {
                object2 = "null";
                break;
            }
            default: {
                object2 = "\"" + this.escape(String.valueOf(object)) + "\"";
            }
        }
        return object2;
    }

    public String escape(String string) {
        return string.replace("\\", "\\\\").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replaceAll("\\p{C}", "?").replace("\"", "\\\"");
    }

    public boolean setError(String string) {
        this.error = true;
        this.errorText = string;
        return false;
    }
}

