/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

public class Jackson {
    public static boolean readBoolean(JsonNode jsonNode, String string) {
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 != null && !jsonNode2.isNull() && jsonNode2.isBoolean()) {
            return jsonNode2.asBoolean();
        }
        return false;
    }

    public static int readInt(JsonNode jsonNode, String string) {
        if (jsonNode == null || jsonNode.isNull() || string == null) {
            return 0;
        }
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 != null && !jsonNode2.isNull() && jsonNode2.isNumber()) {
            return jsonNode2.asInt(0);
        }
        return 0;
    }

    public static byte readByte(JsonNode jsonNode, String string) {
        return (byte)Jackson.readInt(jsonNode, string);
    }

    public static long readLong(JsonNode jsonNode, String string) {
        if (jsonNode == null || jsonNode.isNull() || string == null) {
            return 0L;
        }
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 != null && !jsonNode2.isNull() && jsonNode2.isNumber()) {
            return jsonNode2.asLong(0L);
        }
        return 0L;
    }

    public static double readDouble(JsonNode jsonNode, String string) {
        if (jsonNode == null || jsonNode.isNull() || string == null) {
            return 0.0;
        }
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 != null && !jsonNode2.isNull()) {
            double d = jsonNode2.asDouble();
            if (Double.isNaN(d)) {
                d = 0.0;
            }
            return d;
        }
        return 0.0;
    }

    public static JsonNode create(String string) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.readTree(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String read(JsonNode jsonNode, String string) {
        if (jsonNode == null || jsonNode.isNull() || string == null) {
            return "";
        }
        JsonNode jsonNode2 = jsonNode.get(string);
        if (jsonNode2 == null || jsonNode2.isNull() || !jsonNode2.isTextual()) {
            return "";
        }
        String string2 = jsonNode2.asText();
        return string2 == null ? "" : string2;
    }

    public static String read(String string, String string2) {
        JsonNode jsonNode = Jackson.create(string);
        return Jackson.read(jsonNode, string2);
    }
}

