/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.sysranger.common.utils.CallResult;
import com.sysranger.common.utils.Debugger;
import com.sysranger.common.utils.Jackson;
import com.sysranger.common.utils.JsonUtils;
import com.sysranger.common.utils.SRCloser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class SRPoster {
    private int connectionTimeout = 10000;
    private int readTimeout = 30000;

    public CallResult postAndCheck(String string, HashMap<String, String> hashMap) {
        String string2 = this.post(string, hashMap);
        JsonNode jsonNode = Jackson.create(string2);
        if (jsonNode == null) {
            return CallResult.error("Cannot parse api response");
        }
        if (Jackson.readBoolean(jsonNode, "success")) {
            return CallResult.success();
        }
        String string3 = Jackson.read(jsonNode, "error");
        if (string3.isBlank()) {
            string3 = "Unknown Error";
        }
        return CallResult.error(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String string, HashMap<String, String> hashMap) {
        String string2;
        hashMap.put("rnd", "" + System.currentTimeMillis());
        String string3 = this.getFormDataAsString(hashMap);
        Debugger.print("SRPoster.post:" + string + " > " + (string3.length() > 100 ? string3.substring(0, 100) : string3));
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0");
            httpURLConnection.setRequestProperty("Cache-Control", "private, no-store, no-cache, must-revalidate");
            httpURLConnection.setRequestProperty("Pragma", "no-cache");
            httpURLConnection.setRequestProperty("charset", StandardCharsets.UTF_8.name());
            httpURLConnection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setReadTimeout(this.readTimeout);
            httpURLConnection.setConnectTimeout(this.connectionTimeout);
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoOutput(true);
            byte[] byArray = string3.getBytes(StandardCharsets.UTF_8);
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(byArray.length));
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                outputStream.write(byArray);
                outputStream.flush();
            }
            int n = httpURLConnection.getResponseCode();
            String string4 = "";
            string4 = n == 200 ? this.readStream(httpURLConnection.getInputStream()) : this.readError(httpURLConnection);
            Debugger.print("SRPoster.response Code:" + n + " MSG:" + string4);
            string2 = string4;
        }
        catch (Exception exception) {
            String string5;
            try {
                string5 = JsonUtils.error(exception.getMessage());
            }
            catch (Throwable throwable) {
                SRCloser.close(httpURLConnection);
                httpURLConnection = null;
                throw throwable;
            }
            SRCloser.close(httpURLConnection);
            httpURLConnection = null;
            return string5;
        }
        SRCloser.close(httpURLConnection);
        httpURLConnection = null;
        return string2;
    }

    private String readError(HttpURLConnection httpURLConnection) {
        Object object = "Error:";
        try {
            object = httpURLConnection.getResponseMessage() + " " + httpURLConnection.getResponseCode();
        }
        catch (Exception exception) {
            object = (String)object + "No message from server." + exception.getMessage();
        }
        object = (String)object + this.readStream(httpURLConnection.getErrorStream());
        return JsonUtils.error((String)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStream(InputStream inputStream) {
        block7: {
            String string;
            if (inputStream == null) {
                return null;
            }
            BufferedReader bufferedReader = null;
            try {
                String string2;
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2);
                }
                string = stringBuilder.toString();
                SRCloser.close(bufferedReader);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                break block7;
            }
            finally {
                SRCloser.close(bufferedReader);
                SRCloser.close(inputStream);
                bufferedReader = null;
                inputStream = null;
            }
            SRCloser.close(inputStream);
            bufferedReader = null;
            inputStream = null;
            return string;
        }
        return null;
    }

    private String getFormDataAsString(Map<String, String> map) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("&");
                }
                stringBuilder.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8));
                stringBuilder.append("=");
                stringBuilder.append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

