/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.mailsender;

import com.sysranger.common.database.QueryResult;
import com.sysranger.common.utils.Debugger;
import com.sysranger.common.utils.Utils;
import com.sysranger.mailsender.SRMailAttachment;
import java.io.File;
import java.util.ArrayList;

public class SRMail {
    public static final byte INIT = 0;
    public static final byte HANDLING = 1;
    public static final byte ERROR = 10;
    public static final byte CANCELLED = 20;
    public static final byte SENT = 99;
    public String from = "info@sysranger.com";
    public String to = "";
    public String body = "";
    public String subject = "";
    public long id = 0L;
    public volatile byte status = 0;
    public long lastTry = 0L;
    public long tries = 0L;
    public long created = 0L;
    public String error = "";
    public String response = "";
    public long sent = 0L;
    public String attachmentFile = "";
    public String attachmentName = "";
    public String extension = "";
    public String readError = "";

    public static SRMail fromDB(QueryResult queryResult) {
        SRMail sRMail = new SRMail();
        try {
            sRMail.status = queryResult.getByte("status");
            sRMail.from = queryResult.getString("m_from");
            sRMail.to = queryResult.getString("m_to");
            sRMail.subject = queryResult.getString("subject");
            sRMail.body = queryResult.getString("body");
            sRMail.tries = queryResult.getLong("try");
            sRMail.lastTry = queryResult.getLong("lasttry");
            sRMail.created = queryResult.getLong("created");
            sRMail.attachmentName = queryResult.getString("attachmentname");
            sRMail.attachmentFile = queryResult.getString("attachmentfile");
            sRMail.extension = queryResult.getString("extension");
            sRMail.id = queryResult.getLong("id");
        }
        catch (Exception exception) {
            sRMail.readError = Utils.exception(exception);
        }
        return sRMail;
    }

    public ArrayList<SRMailAttachment> getAttachment() {
        if (this.attachmentName == null) {
            return null;
        }
        if (this.attachmentFile == null) {
            return null;
        }
        if (this.attachmentName.isBlank()) {
            return null;
        }
        if (this.attachmentFile.isBlank()) {
            return null;
        }
        String string = "C:\\xampp\\htdocs\\monitor.sysranger.com\\upload\\mail\\" + this.attachmentFile;
        try {
            File file = new File(string);
            if (!file.exists()) {
                return null;
            }
            SRMailAttachment sRMailAttachment = new SRMailAttachment();
            sRMailAttachment.filename = this.attachmentName;
            sRMailAttachment.path = string;
            ArrayList<SRMailAttachment> arrayList = new ArrayList<SRMailAttachment>();
            arrayList.add(sRMailAttachment);
            return arrayList;
        }
        catch (Exception exception) {
            Debugger.error(string + " does not exist");
            return null;
        }
    }

    public String toString() {
        String string = this.body;
        if (this.body != null && this.body.length() > 20) {
            string = this.body.substring(0, 20);
        }
        return this.status + " -  [" + this.id + "] " + this.to + "-" + this.subject + " >" + string + " - " + this.attachmentName;
    }
}

