/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.updater;

import com.sysranger.updater.Debugger;
import com.sysranger.updater.FileDownloader;
import com.sysranger.updater.FileList;
import com.sysranger.updater.GUI;
import com.sysranger.updater.SRFile;
import com.sysranger.updater.SRUpdaterGUI;
import com.sysranger.updater.Utils;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class SRUpdater
extends Thread {
    private long wait = 100L;
    private String host = "https://monitor.sysranger.com/files/downloads/";
    private String version = "0.116";
    private String appName = "";

    public SRUpdater(String[] stringArray) {
        Debugger.init();
        if (!this.parseArguments(stringArray)) {
            this.printInfo("Incorrect arguments");
            return;
        }
        this.start();
    }

    private boolean parseArguments(String[] stringArray) {
        block14: for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = "";
            if (!(string.equals("-help") || string.equals("-console") || string.equals("-wait") || ++i >= stringArray.length)) {
                string2 = stringArray[i];
            }
            System.out.println(string + " " + string2);
            switch (string) {
                case "-app": {
                    if (this.readAppName(string2)) continue block14;
                    return false;
                }
                case "-wait": {
                    this.wait = 5000L;
                    continue block14;
                }
                case "-help": {
                    return this.printInfo("");
                }
                case "-host": {
                    this.readHost(string2);
                    continue block14;
                }
                case "-console": {
                    GUI.ignore = true;
                }
            }
        }
        return true;
    }

    @Override
    public void run() {
        if (!GraphicsEnvironment.isHeadless() && !GUI.ignore) {
            GUI.gui = new SRUpdaterGUI(this);
            GUI.enabled = true;
        }
        Debugger.print("Updater[" + this.version + "] starting from host " + this.host);
        this.appName = this.getAppName();
        if (this.appName.isEmpty()) {
            Debugger.error("No file to update");
            return;
        }
        while (true) {
            if (!this.isLocked()) break;
            Debugger.print("App is locked");
            this.signalApp();
            Utils.sleep(1000L);
        }
        this.removeSignal();
        boolean bl = this.update(this.appName);
        if (bl) {
            Debugger.print("-------------- COMPLETED -------------------");
            Utils.sleep(this.wait);
        }
        System.exit(0);
    }

    private boolean signalApp() {
        try {
            File file = new File("singleinstancesignal");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.close();
        }
        catch (Exception exception) {
            Debugger.error("Cannot create multiple instance signal file");
            return false;
        }
        return true;
    }

    private boolean removeSignal() {
        try {
            File file = new File("singleinstancesignal");
            return file.delete();
        }
        catch (Exception exception) {
            Debugger.error("Cannot remove multiple instance signal file");
            return false;
        }
    }

    private boolean isLocked() {
        try {
            File file = new File("singleinstancelock");
            if (!file.exists()) {
                return false;
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            FileLock fileLock = randomAccessFile.getChannel().tryLock();
            if (fileLock != null) {
                try {
                    fileLock.release();
                    randomAccessFile.close();
                    file.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
            try {
                randomAccessFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            return true;
        }
        catch (Exception exception) {
            Debugger.error("Unable to create Lock file");
            exception.printStackTrace();
            return false;
        }
    }

    private LinkedList<String> getAppList() {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = Utils.textFromURL(this.host + "updater.php?app=list");
        Debugger.print("App List:" + string);
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            linkedList.add(stringArray[i]);
        }
        return linkedList;
    }

    private String getAppName() {
        if (!this.appName.isEmpty()) {
            return this.appName;
        }
        LinkedList<String> linkedList = this.getAppList();
        File file = new File(".");
        for (File file2 : file.listFiles()) {
            String string;
            String string2;
            if (!file2.isFile() || !(string2 = file2.getName()).endsWith(".jar") || string2.endsWith("Updater.jar") || !linkedList.contains(string = string2.replace(".jar", ""))) continue;
            return string;
        }
        return "";
    }

    private FileList getFiles(String string) {
        FileList fileList = new FileList();
        String string2 = this.host + "updater.php?app=" + string;
        String string3 = Utils.textFromURL(string2);
        Debugger.print("File List:" + string3);
        String[] stringArray = string3.split(";");
        if (stringArray.length < 2) {
            return fileList;
        }
        String[] stringArray2 = stringArray[0].split(Pattern.quote("|"));
        if (!stringArray2[0].equals("root")) {
            return fileList;
        }
        fileList.root = stringArray2[1];
        for (int i = 1; i < stringArray.length; ++i) {
            Debugger.print(stringArray[i]);
            stringArray2 = stringArray[i].split(Pattern.quote("|"));
            if (stringArray2.length < 3 || !stringArray2[0].equals("file")) continue;
            String string4 = stringArray2[1];
            long l = Utils.toLong(stringArray2[2]);
            fileList.files.add(new SRFile(string4, l));
        }
        return fileList;
    }

    private boolean update(String string) {
        FileList fileList = this.getFiles(string);
        long l = 0L;
        for (SRFile sRFile : fileList.files) {
            String string2 = this.host + fileList.root + "/" + sRFile.name;
            boolean bl = new FileDownloader().download(string2, sRFile);
            if (bl) {
                ++l;
            }
            if (GUI.enabled) {
                GUI.gui.progress((double)l / (double)fileList.files.size() * 100.0);
            }
            Debugger.print("Downloaded [" + l + " / " + fileList.files.size() + "]:" + sRFile.name);
        }
        return true;
    }

    private boolean readHost(String string) {
        if (string == null || string.isEmpty()) {
            return this.printInfo("Incorrect option:host");
        }
        if (string.length() < 5) {
            return this.printInfo("Host is not valid:" + string);
        }
        String string2 = "http";
        if (string.equals("sysranger.com")) {
            string2 = "https";
        }
        this.host = string2 + "://" + string + "/files/downloads/";
        return true;
    }

    private boolean readAppName(String string) {
        if (string.isEmpty()) {
            return this.printInfo("Incorrect option:app");
        }
        this.appName = string;
        return true;
    }

    private boolean printInfo(String string) {
        System.out.println(string);
        String string2 = "Command line arguments;";
        string2 = string2 + "\n-app \t\t\t The name of application to be updated/installed";
        string2 = string2 + "\n-wait \t\t\t Wait before start app";
        string2 = string2 + "\n-host <hostname> \t The host name of monitoring application server.";
        string2 = string2 + "\n-console \t\t\t Run application on console mode (no use interface)";
        string2 = string2 + "\n";
        System.out.println(string2);
        return false;
    }

    public static void main(String[] stringArray) {
        new SRUpdater(stringArray);
    }
}

