/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.app;

import com.sysranger.common.utils.CallResult;
import com.sysranger.common.utils.Debugger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.TimeUnit;

public class WindowsCommandExecuter {
    public static CallResult execute(String ... stringArray) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            Process process = processBuilder.start();
            int n = process.waitFor();
            if (n != 0) {
                return CallResult.error("WindowsCommandExecuter Error:" + String.valueOf(stringArray) + " ExitCode:" + n);
            }
            return CallResult.success();
        }
        catch (Exception exception) {
            return CallResult.error("WindowsCommandExecuter Error:" + exception.getMessage());
        }
    }

    public static CallResult execute(long l, String ... stringArray) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            Process process = processBuilder.start();
            process.waitFor(l, TimeUnit.MILLISECONDS);
            int n = process.exitValue();
            if (n != 0) {
                return CallResult.error("WindowsCommandExecuter Error:" + String.valueOf(stringArray) + " ExitCode:" + n);
            }
            return CallResult.success();
        }
        catch (Exception exception) {
            return CallResult.error("WindowsCommandExecuter Error:" + exception.getMessage());
        }
    }

    public static CallResult executeRuntime(String ... stringArray) {
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return CallResult.error(iOException.getMessage());
        }
        return CallResult.success();
    }

    public static CallResult executeWithResponse(String ... stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            return CallResult.error("WindowsCommandExecuter Command is null");
        }
        String string = String.join((CharSequence)" ", stringArray);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            Process process = processBuilder.start();
            int n = process.waitFor();
            Object object = WindowsCommandExecuter.output(process, false);
            object = (String)object + WindowsCommandExecuter.output(process, true);
            if (n == 0) {
                Debugger.print("WindowsCommandExecuter Success:" + string + " >>>" + (String)object);
                return CallResult.success((String)object);
            }
            Debugger.error("WindowsCommandExecuter Error  Code:" + n + "  > " + string + " >>>" + (String)object);
            return CallResult.error("Code:" + n + " " + (String)object);
        }
        catch (Exception exception) {
            return CallResult.error("WindowsCommandExecuter Error:" + string + " >>>" + exception.getMessage());
        }
    }

    private static String output(Process process, boolean bl) {
        Object object;
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        try {
            inputStream = bl ? process.getErrorStream() : process.getInputStream();
            object = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader((Reader)object);
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
        Object object2 = "";
        try {
            while ((object = bufferedReader.readLine()) != null) {
                object2 = (String)object2 + (String)object;
            }
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
        return object2;
    }
}

