/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.database;

import com.sysranger.common.database.Database;
import com.sysranger.common.database.QueryResult;
import com.sysranger.common.database.SRQuery;
import com.sysranger.common.utils.Debugger;
import com.sysranger.common.utils.SRFileLogger;
import com.sysranger.common.utils.Utils;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SRQueryQueue
extends Thread {
    private Database db;
    private ConcurrentLinkedQueue<SRQuery> queries = new ConcurrentLinkedQueue();
    private long wait = 5000L;
    private volatile boolean exit = false;
    private String dbName = "";

    public SRQueryQueue(Database database) {
        super("SysRanger-SRQueryQueue - " + database.name);
        this.db = database;
        this.dbName = database.strippedName();
    }

    public void add(SRQuery sRQuery) {
        this.queries.add(sRQuery);
    }

    public void addAll(List<SRQuery> list) {
        this.queries.addAll(list);
    }

    public void setWait(long l) {
        this.wait = l;
    }

    private void error(String string) {
        SRFileLogger.logDaily("QueryQueue_" + this.dbName, this.db.name + " ERROR - " + string);
    }

    private void executeQueries() {
        SRQuery sRQuery = null;
        while ((sRQuery = this.queries.poll()) != null) {
            try {
                QueryResult queryResult = this.db.execute(sRQuery.query, sRQuery.values);
                if (!queryResult.error) continue;
                this.error(queryResult.errorMessage + " QUERY:" + sRQuery.query);
                Debugger.debug(this.db.name + " - " + queryResult.errorMessage + " -- " + sRQuery.query);
            }
            catch (Exception exception) {
                this.error(Utils.exception(exception));
            }
        }
    }

    @Override
    public void run() {
        while (!this.exit) {
            Utils.sleep(this.wait);
            try {
                this.executeQueries();
            }
            catch (Exception exception) {
                this.error(Utils.exception(exception));
            }
        }
    }

    public void dispose() {
        this.exit = true;
    }
}

