/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.utils;

import com.sysranger.common.srjson.SRJson;
import com.sysranger.common.utils.Utils;

public class CallResult {
    public boolean error = false;
    public String message = "";
    public String exception = "";
    public Object value = null;

    public CallResult() {
    }

    public CallResult(boolean bl, String string) {
        this.error = bl;
        this.message = string;
    }

    public String json() {
        SRJson sRJson = new SRJson();
        sRJson.add("success", !this.error);
        sRJson.add("error", this.message);
        sRJson.add("exception", this.exception);
        return sRJson.toString();
    }

    public CallResult setError(String string) {
        if (string == null) {
            string = "";
        }
        string = string.replaceAll("\\R+", " ");
        this.message = string = string.trim();
        this.error = true;
        return this;
    }

    public static CallResult success() {
        return new CallResult(false, "");
    }

    public static CallResult success(String string) {
        return new CallResult(false, string);
    }

    public static CallResult success(Object object) {
        CallResult callResult = new CallResult(false, "");
        callResult.value = object;
        return callResult;
    }

    public static CallResult error(String string) {
        if (string == null) {
            string = "";
        }
        string = string.replaceAll("\\R+", " ");
        string = string.trim();
        return new CallResult(true, string);
    }

    public static CallResult error(String string, String string2) {
        if (string == null) {
            string = "";
        }
        CallResult callResult = new CallResult(true, string);
        callResult.exception = string2;
        return callResult;
    }

    public static CallResult error(String string, Exception exception) {
        if (string == null) {
            string = "";
        }
        string = string.replaceAll("\\R+", " ");
        string = string.trim();
        CallResult callResult = new CallResult(true, string);
        if (exception == null) {
            return callResult;
        }
        String string2 = exception.getClass().getSimpleName();
        String string3 = exception.getCause() != null ? exception.getCause().getClass().getSimpleName() : "";
        String string4 = exception.getMessage();
        callResult.exception = string2 + " Cause:" + string3 + ">" + string4;
        return callResult;
    }

    public static CallResult error(Exception exception) {
        String string = Utils.exception(exception);
        CallResult callResult = new CallResult(true, string);
        return callResult;
    }
}

