/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.utils;

import com.sysranger.common.utils.JsonString;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class JsonUtils {
    public static String error(String string) {
        string = JsonUtils.escape(string);
        return "{\"success\":false,\"error\":\"" + string + "\"}";
    }

    public static String error(String string, Object ... objectArray) {
        Object object = "{\"success\":false,\"error\":\"" + string + "\",";
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object2 = objectArray[i + 1];
            String string2 = JsonUtils.getField(object2);
            object = (String)object + "\"" + String.valueOf(objectArray[i]) + "\":" + string2 + ",";
        }
        if (((String)object).length() > 1) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        object = (String)object + "}";
        return object;
    }

    public static String error(Map<String, Object> map) {
        map.put("success", false);
        return JsonUtils.fromMap(map);
    }

    public static String success() {
        return "{\"success\":true}";
    }

    public static String success(Object ... objectArray) {
        Object object = "{\"success\":true,";
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object2 = objectArray[i + 1];
            String string = JsonUtils.getField(object2);
            object = (String)object + "\"" + String.valueOf(objectArray[i]) + "\":" + string + ",";
        }
        if (((String)object).length() > 1) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        object = (String)object + "}";
        return object;
    }

    public static String fromArrayList(String string, ArrayList<Object> arrayList) {
        String string2 = "{\"success\":true,\"" + string + "\":[";
        Object object = "";
        for (Object object2 : arrayList) {
            String string3 = JsonUtils.getField(object2);
            object = (String)object + string3 + ",";
        }
        if (((String)object).length() > 1) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        string2 = string2 + (String)object;
        string2 = string2 + "]}";
        return string2;
    }

    public static String toJSON(Object ... objectArray) {
        Object object = "{";
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object2 = objectArray[i + 1];
            String string = JsonUtils.getField(object2);
            object = (String)object + "\"" + String.valueOf(objectArray[i]) + "\":" + string + ",";
        }
        if (((String)object).length() > 1) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        object = (String)object + "}";
        return object;
    }

    public static String getField(Object object) {
        String string;
        Object object2 = "null";
        switch (string = object == null ? "null" : object.getClass().getSimpleName()) {
            case "Integer": 
            case "Double": 
            case "Long": {
                object2 = String.valueOf(object);
                break;
            }
            case "Boolean": {
                object2 = (Boolean)object != false ? "true" : "false";
                break;
            }
            case "ArrayList": {
                object2 = JsonUtils.parseArray(object);
                break;
            }
            case "JsonString": {
                object2 = ((JsonString)object).text;
                break;
            }
            case "null": {
                object2 = "null";
                break;
            }
            default: {
                object2 = "\"" + JsonUtils.escape(String.valueOf(object)) + "\"";
            }
        }
        return object2;
    }

    public static String fromMap(Map<String, Object> map) {
        Object object = "{";
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            Object object2 = entry.getValue();
            String string = JsonUtils.getField(object2);
            object = (String)object + "\"" + entry.getKey() + "\":" + string + ",";
        }
        if (((String)object).length() > 1) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        object = (String)object + "}";
        return object;
    }

    public static String parseArray(Object object) {
        if (object == null) {
            return "[]";
        }
        ArrayList arrayList = (ArrayList)object;
        Object object2 = "[";
        for (Map map : arrayList) {
            object2 = (String)object2 + JsonUtils.fromMap(map) + ",";
        }
        if (((String)object2).length() > 1) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
        }
        object2 = (String)object2 + "]";
        return object2;
    }

    public static String fromStringMap(Map<String, String> map, boolean bl) {
        Object object = "{\"success\":" + bl + ",";
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            object = (String)object + "\"" + entry.getKey() + "\":\"" + entry.getValue() + "\",";
        }
        if (((String)object).length() > 1) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        object = (String)object + "}";
        return object;
    }

    public static String fromResultset(ResultSet resultSet) {
        Object object = "{\"rows\":[";
        if (resultSet == null) {
            return (String)object + "],\"success\":false}";
        }
        int n = 0;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                Object object2 = "{";
                n = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= n; ++i) {
                    String string = resultSetMetaData.getColumnName(i);
                    Object object3 = resultSet.getObject(string);
                    String string2 = JsonUtils.getField(object3);
                    object2 = (String)object2 + "\"" + string + "\":" + string2 + ",";
                }
                if (((String)object2).length() > 2) {
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                }
                object2 = (String)object2 + "},";
                if (((String)object).length() + ((String)object2).length() > 50000) break;
                object = (String)object + (String)object2;
            }
            if (((String)object).length() > 2) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object = (String)object + "],\"success\":true}";
        return object;
    }

    public static String escape(String string) {
        return string.replace("\\", "\\\\").replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f").replaceAll("\\p{C}", "?").replace("\"", "\\\"");
    }
}

