/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.common.utils;

import com.sysranger.common.app.SRApp;
import com.sysranger.common.database.DatabaseSQLite;
import com.sysranger.common.database.LogDBUpdater;
import com.sysranger.common.database.QueryResult;
import com.sysranger.common.database.SRLogEntry;
import com.sysranger.common.database.SRQuery;
import com.sysranger.common.srjson.SRJson;
import com.sysranger.common.srjson.SRJsonNode;
import com.sysranger.common.utils.CallResult;
import com.sysranger.common.utils.Debugger;
import com.sysranger.common.utils.JsonUtils;
import com.sysranger.common.utils.SRCloser;
import com.sysranger.common.utils.Time;
import com.sysranger.common.utils.Utils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SRLogger
extends Thread {
    SimpleDateFormat df;
    private ConcurrentLinkedQueue<SRLogEntry> errors = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<SRLogEntry> infos = new ConcurrentLinkedQueue();
    private DatabaseSQLite db;
    private long tick = 0L;
    private SRApp app;
    private volatile boolean exit = false;

    public SRLogger(SRApp sRApp) {
        super("SysRanger-Logger");
        this.app = sRApp;
        this.db = new DatabaseSQLite("data/logs.db");
        this.db.queue.setWait(2000L);
        CallResult callResult = this.db.connect();
        if (callResult.error) {
            Debugger.error("Cannot connect to log database");
        }
        new LogDBUpdater(this.db);
        String string = "yyyy.MM.dd HH:mm:ss";
        this.df = new SimpleDateFormat(string);
        System.setErr(new PrintStream(System.err){

            @Override
            public void println(String string) {
                super.println(string);
                if (SRLogger.this.errors.size() > 10000) {
                    return;
                }
                SRLogger.this.errors.add(new SRLogEntry(1, System.currentTimeMillis(), string));
            }
        });
        System.setOut(new PrintStream(System.out){

            @Override
            public void println(String string) {
                super.println(string);
                if (SRLogger.this.infos.size() > 10000) {
                    return;
                }
                SRLogger.this.infos.add(new SRLogEntry(0, System.currentTimeMillis(), string));
            }
        });
        this.start();
    }

    @Override
    public void run() {
        Time time = new Time();
        this.clear();
        while (!this.exit) {
            Utils.sleep(1000L);
            this.writeErrors();
            this.writeInfos();
            if (this.tick % 5L == 0L) {
                this.signal();
                this.db.tick();
            }
            if (time.elapsed(86400000L)) {
                this.clear();
            }
            ++this.tick;
        }
    }

    public DatabaseSQLite database() {
        return this.db;
    }

    private void signal() {
        long l = System.currentTimeMillis();
        String string = "update srl_signal set tm=?,status=?";
        SRQuery sRQuery = new SRQuery(string, l, this.app.status());
        this.db.queue(sRQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeErrors() {
        if (this.errors.isEmpty()) {
            return;
        }
        BufferedWriter bufferedWriter = null;
        String string = "logs/errors_" + Utils.dayFileName() + ".txt";
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string, true));
            while (!this.errors.isEmpty()) {
                SRLogEntry sRLogEntry = this.errors.poll();
                String string2 = this.df.format(new Date(sRLogEntry.time));
                Object object = sRLogEntry.message;
                object = ((String)object).replaceAll("\n", " ");
                object = string2 + " " + (String)object;
                bufferedWriter.write((String)object + "\n");
                this.addToDB(sRLogEntry);
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            SRCloser.close(bufferedWriter);
        }
        catch (Throwable throwable) {
            SRCloser.close(bufferedWriter);
            throw throwable;
        }
        SRCloser.close(bufferedWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInfos() {
        if (this.infos.isEmpty()) {
            return;
        }
        BufferedWriter bufferedWriter = null;
        try {
            String string = "logs/logs_" + Utils.dayFileName() + ".txt";
            bufferedWriter = new BufferedWriter(new FileWriter(string, true));
            while (!this.infos.isEmpty()) {
                SRLogEntry sRLogEntry = this.infos.poll();
                String string2 = this.df.format(new Date(sRLogEntry.time));
                Object object = sRLogEntry.message;
                object = ((String)object).replaceAll("\n", " ");
                object = string2 + " " + (String)object;
                bufferedWriter.write((String)object + "\n");
                this.addToDB(sRLogEntry);
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            SRCloser.close(bufferedWriter);
        }
        catch (Throwable throwable) {
            SRCloser.close(bufferedWriter);
            throw throwable;
        }
        SRCloser.close(bufferedWriter);
    }

    private void addToDB(SRLogEntry sRLogEntry) {
        String string = "insert into srl_logs (tm,type,msg) values (?,?,?)";
        SRQuery sRQuery = new SRQuery(string, sRLogEntry.time, sRLogEntry.type, sRLogEntry.message);
        this.db.queue(sRQuery);
    }

    private void clear() {
        this.clearDB();
        this.clearFiles();
    }

    private void clearDB() {
        long l = System.currentTimeMillis();
        long l2 = l - 2592000000L;
        SRQuery sRQuery = new SRQuery("delete from srl_logs where tm<" + l2, new Object[0]);
        this.db.queue(sRQuery);
    }

    public synchronized String json(long l, byte by, byte by2, int n) {
        if (l < 1L) {
            l = Long.MAX_VALUE;
        }
        if (n < 10) {
            n = 10;
        }
        if (n > 500) {
            n = 500;
        }
        String string = "<";
        String string2 = "desc";
        if (by2 > 0) {
            string = ">";
            string2 = "asc";
        }
        Object object = by > 0 ? " and type=" + by : "";
        String string3 = "select tm,msg,type from srl_logs where tm" + string + l + (String)object + " order by tm " + string2 + " limit " + n;
        QueryResult queryResult = this.db.select(string3, new Object[0]);
        if (queryResult.error) {
            return JsonUtils.error(queryResult.errorMessage);
        }
        SRJson sRJson = new SRJson();
        SRJsonNode sRJsonNode = sRJson.addArray("logs");
        long l2 = 0L;
        long l3 = Long.MAX_VALUE;
        while (queryResult.next()) {
            SRJsonNode sRJsonNode2 = new SRJsonNode();
            long l4 = queryResult.getLong("tm");
            sRJsonNode2.add("d", l4);
            sRJsonNode2.add("t", queryResult.getByte("type"));
            sRJsonNode2.add("m", queryResult.getString("msg"));
            sRJsonNode.addToArray(sRJsonNode2);
            if (l4 > l2) {
                l2 = l4;
            }
            if (l4 >= l3) continue;
            l3 = l4;
        }
        sRJson.add("start", l);
        sRJson.add("limit", n);
        sRJson.add("direction", by2);
        boolean bl = false;
        if (l < 10000000000000L) {
            string3 = "select tm from srl_logs where tm>" + l2 + (String)object + " limit 1";
            bl = this.db.doesExist(string3, new Object[0]);
        }
        string3 = "select tm from srl_logs where tm<" + l3 + (String)object + " limit 1";
        boolean bl2 = this.db.doesExist(string3, new Object[0]);
        sRJson.add("hasnext", bl);
        sRJson.add("hasprevious", bl2);
        return sRJson.toString();
    }

    private void clearFiles() {
        long l = System.currentTimeMillis() - 2592000000L;
        try {
            File file = new File("logs");
            if (!file.isDirectory()) {
                return;
            }
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file2 : fileArray) {
                String string;
                if (!file2.isFile() || !(string = file2.getName()).endsWith(".txt") || file2.lastModified() > l || !string.startsWith("logs") && !string.startsWith("errors")) continue;
                this.delete(file2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean delete(File file) {
        try {
            return file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void dispose() {
        this.exit = true;
        try {
            System.setOut(null);
            System.setErr(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.writeErrors();
        this.writeInfos();
        this.db.close();
    }
}

