/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.server.setup;

import com.sysranger.common.app.WindowsCommandExecuter;
import com.sysranger.common.interfaces.CallListener;
import com.sysranger.common.utils.CallResult;
import com.sysranger.common.utils.Time;
import com.sysranger.common.utils.Utils;
import com.sysranger.server.setup.ServerServiceInstaller;
import com.sysranger.server.setup.ServerSetupGUI;
import com.sysranger.server.setup.ServiceController;
import com.sysranger.server.setup.SetupPanel;
import com.sysranger.server.setup.update.SysRangerUpdater;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import oshi.SystemInfo;

public class ServerSetupPanelInit
extends JPanel
implements ActionListener,
SetupPanel,
Runnable {
    private ServerSetupGUI gui;
    private SystemInfo info;
    private JButton buttonUpdate;
    private JButton buttonInstall;
    private JButton buttonStop;
    private JButton buttonStart;
    DefaultStyledDocument document = new DefaultStyledDocument();
    JTextPane txtDebug = new JTextPane(this.document);
    private Time timerCheckService = new Time();
    private volatile boolean serviceRunning = false;
    private volatile boolean installStarted = false;
    private final String serviceName = "SysRanger Monitoring";

    public ServerSetupPanelInit(ServerSetupGUI serverSetupGUI) {
        this.gui = serverSetupGUI;
        this.create();
        new Thread(this).start();
    }

    private void create() {
        this.buttonUpdate = new JButton("Update");
        this.buttonInstall = new JButton("Install");
        this.buttonStart = new JButton("Start Service");
        this.buttonStop = new JButton("Stop Service");
        this.buttonUpdate.addActionListener(this);
        this.buttonInstall.addActionListener(this);
        this.buttonStart.addActionListener(this);
        this.buttonStop.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.disableButtons();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(20, 0, 20, 0));
        jPanel2.add((Component)this.txtDebug, "Center");
        jPanel.add(jPanel2);
        this.txtDebug.setOpaque(false);
        this.txtDebug.setEditable(false);
        this.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this.buttonInstall, "West");
        jPanel3.add((Component)this.buttonUpdate, "East");
        jPanel3.add(this.buttonStart);
        jPanel3.add(this.buttonStop);
        jPanel3.setBorder(new EmptyBorder(20, 0, 0, 0));
        jPanel4.add((Component)jPanel3, "South");
        this.add((Component)jPanel4, "South");
    }

    @Override
    public void init() {
        System.out.println("ServerSetupPanelInit.init");
        this.check();
    }

    private void install() {
        this.buttonInstall.setEnabled(false);
        this.installStarted = true;
        this.print("Installing service...");
        new ServerServiceInstaller(new CallListener(){

            @Override
            public boolean completed(CallResult callResult) {
                ServerSetupPanelInit.this.print("Install completed");
                ServerSetupPanelInit.this.installStarted = false;
                if (callResult.error) {
                    ServerSetupPanelInit.this.error(callResult.message);
                    ServerSetupPanelInit.this.buttonInstall.setEnabled(true);
                } else {
                    ServerSetupPanelInit.this.check();
                }
                return true;
            }
        });
    }

    private void forceCheck() {
        ServiceController serviceController = this.gui.manager().serviceController();
        serviceController.force();
    }

    private void check() {
        ServiceController serviceController = this.gui.manager().serviceController();
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (serviceController.status == 3) {
            bl = false;
            bl3 = false;
            bl2 = true;
        }
        if (serviceController.status == 2) {
            bl3 = true;
            bl = false;
        }
        bl4 = bl;
        this.buttonStart.setEnabled(bl);
        this.buttonStop.setEnabled(bl2);
        this.buttonInstall.setEnabled(bl3);
        this.buttonUpdate.setEnabled(bl4);
    }

    private void debug(String string, Color color) {
        StyleContext styleContext = new StyleContext();
        Style style = styleContext.addStyle("style", null);
        StyleConstants.setForeground(style, color);
        StyleConstants.setFontSize(style, 14);
        try {
            this.document.insertString(0, string + "\n", style);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean print(String string) {
        this.debug(string, Color.BLACK);
        return true;
    }

    private boolean error(String string) {
        this.debug(string, Color.RED);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttonInstall) {
            this.install();
        } else if (object == this.buttonUpdate) {
            this.update();
        } else if (object == this.buttonStart) {
            this.start();
        } else if (object == this.buttonStop) {
            this.stop();
        }
    }

    private void update() {
        this.buttonUpdate.setEnabled(false);
        this.print("Updating SysRanger Server...");
        new SysRangerUpdater(new CallListener(){

            @Override
            public boolean completed(CallResult callResult) {
                ServerSetupPanelInit.this.print("Update started");
                if (callResult.error) {
                    ServerSetupPanelInit.this.error(callResult.message);
                    ServerSetupPanelInit.this.buttonUpdate.setEnabled(true);
                } else {
                    ServerSetupPanelInit.this.check();
                }
                return true;
            }
        });
    }

    private void start() {
        this.disableButtons();
        String[] stringArray = new String[]{"cmd.exe", "/c", "net", "start", "SysRanger Monitoring"};
        CallResult callResult = WindowsCommandExecuter.executeWithResponse(stringArray);
        if (callResult.error) {
            this.error(callResult.message);
        } else {
            this.print(callResult.message);
        }
        this.forceCheck();
    }

    private void disableButtons() {
        this.buttonStart.setEnabled(false);
        this.buttonStop.setEnabled(false);
        this.refresh();
    }

    private void stop() {
        this.disableButtons();
        String[] stringArray = new String[]{"cmd.exe", "/c", "net", "stop", "SysRanger Monitoring"};
        CallResult callResult = WindowsCommandExecuter.executeWithResponse(stringArray);
        if (callResult.error) {
            this.error(callResult.message);
        } else {
            this.print(callResult.message);
        }
        this.forceCheck();
    }

    private void refresh() {
        this.repaint();
    }

    @Override
    public void run() {
        while (true) {
            Utils.sleep(500L);
            this.repaint();
            if (!this.timerCheckService.elapsed(1000L)) continue;
            this.check();
        }
    }
}

