/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.server.setup;

import com.sysranger.common.utils.Time;
import com.sysranger.common.utils.Utils;
import java.util.List;
import oshi.SystemInfo;
import oshi.software.os.OSService;
import oshi.software.os.OperatingSystem;

public class ServiceController
extends Thread {
    public volatile String message = "";
    public volatile byte status = 0;
    private volatile boolean exit = false;
    private Time timerCheck = new Time();
    private volatile boolean force = false;
    private SystemInfo info;
    private OperatingSystem ops;

    public ServiceController() {
        this.start();
    }

    @Override
    public void run() {
        while (!this.exit) {
            if (this.timerCheck.elapsed(10000L) || this.force) {
                this.force = false;
                this.check();
            }
            Utils.sleep(200L);
        }
    }

    public void force() {
        this.force = true;
    }

    private boolean check() {
        try {
            return this._check();
        }
        catch (Exception exception) {
            return this.status("Cannot check service - " + Utils.exception(exception), (byte)5);
        }
    }

    private boolean status(String string, byte by) {
        this.status = by;
        this.message = string;
        return true;
    }

    private boolean _check() {
        this.info = new SystemInfo();
        this.ops = this.info.getOperatingSystem();
        List list = this.ops.getServices();
        for (OSService oSService : list) {
            boolean bl;
            String string = oSService.getName();
            if (!string.equals("SysRanger Monitoring")) continue;
            boolean bl2 = bl = oSService.getState() == OSService.State.RUNNING;
            if (bl) {
                return this.status("Service is running", (byte)3);
            }
            return this.status("Service is installed but not running.", (byte)4);
        }
        return this.status("Service is not installed.", (byte)2);
    }
}

