/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.updater;

import com.sysranger.updater.Debugger;
import com.sysranger.updater.SRFile;
import com.sysranger.updater.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class FileDownloader {
    private boolean checkFolder(String string) {
        try {
            Path path = Paths.get(string, new String[0]);
            Path path2 = path.getParent();
            if (path2 == null) {
                return true;
            }
            Path path3 = path2.getFileName();
            if (path3 == null) {
                return false;
            }
            File file = new File(string);
            file.mkdirs();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean alreadyDownloaded(SRFile sRFile) {
        if (sRFile.name.endsWith("bat") || sRFile.name.endsWith("exe") || sRFile.name.endsWith("sh") || sRFile.name.endsWith(".jar") && !sRFile.name.contains("libs")) {
            return false;
        }
        File file = new File(sRFile.name);
        if (!file.exists()) {
            return false;
        }
        return file.length() == sRFile.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(String string, SRFile sRFile) {
        block13: {
            boolean bl;
            string = string + "?v=" + System.currentTimeMillis();
            Debugger.print("Downloading:" + string);
            if (!this.checkFolder(sRFile.name)) {
                return Debugger.error("Cannot create folder:" + sRFile);
            }
            if (this.alreadyDownloaded(sRFile)) {
                return true;
            }
            String string2 = sRFile + "_temp";
            FileOutputStream fileOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                int n;
                URL uRL = new URL(string);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.addRequestProperty("User-Agent", "Mozilla/4.0");
                httpURLConnection.setReadTimeout(50000);
                httpURLConnection.setConnectTimeout(50000);
                bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
                fileOutputStream = new FileOutputStream(string2);
                byte[] byArray = new byte[1024];
                long l = 0L;
                while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                    l += (long)n;
                }
                if (l < 1L) {
                    boolean bl2 = Debugger.error("Cannot download file:" + sRFile);
                    this.closeStreams(bufferedInputStream, fileOutputStream);
                    return bl2;
                }
                File file = new File(string2);
                if (!file.isFile() || !file.exists()) {
                    boolean bl3 = false;
                    this.closeStreams(bufferedInputStream, fileOutputStream);
                    return bl3;
                }
                this.closeStreams(bufferedInputStream, fileOutputStream);
                Utils.sleep(100L);
                File file2 = new File(sRFile.name);
                Files.move(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                if (file2.exists() && sRFile.name.endsWith(".sh")) {
                    this.setExecutable(file2);
                }
                bl = true;
                this.closeStreams(bufferedInputStream, fileOutputStream);
            }
            catch (Exception exception) {
                Debugger.print(exception.getMessage());
                break block13;
            }
            finally {
                this.closeStreams(bufferedInputStream, fileOutputStream);
            }
            return bl;
        }
        return false;
    }

    private void setExecutable(File file) {
        try {
            Debugger.print("Set Executable:" + file.getName());
            file.setExecutable(true);
        }
        catch (Exception exception) {
            Debugger.error(exception.getMessage());
        }
    }

    private void closeStreams(BufferedInputStream bufferedInputStream, FileOutputStream fileOutputStream) {
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

