/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.updater;

import com.sysranger.updater.SRUpdater;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;

public class SRUpdaterGUI
extends JFrame {
    public SRUpdater manager;
    private JTextArea txtDebugger = new JTextArea();
    private JTextArea txtError = new JTextArea();
    private JProgressBar pb = new JProgressBar(0, 100);
    int w = 800;
    int h = 200;

    public SRUpdaterGUI(SRUpdater sRUpdater) {
        super("SysRanger Updater");
        this.manager = sRUpdater;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.out.println("GUI-Unable to set LookAndFeel");
        }
        this.setIcon();
        this.createComponents();
        this.setVisible(true);
        this.setSize(this.w, this.h);
        this.setDefaultCloseOperation(3);
    }

    private void setIcon() {
        try {
            URL uRL = this.getClass().getResource("/images/tray.png");
            if (uRL == null) {
                return;
            }
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            this.setIconImage(image);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void progress(double d) {
        this.pb.setValue((int)d);
    }

    private void createComponents() {
        JScrollPane jScrollPane = new JScrollPane(this.txtDebugger, 22, 32);
        ((DefaultCaret)this.txtDebugger.getCaret()).setUpdatePolicy(2);
        JScrollPane jScrollPane2 = new JScrollPane(this.txtError, 22, 32);
        ((DefaultCaret)this.txtError.getCaret()).setUpdatePolicy(2);
        this.txtError.setForeground(Color.RED);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.pb.setBorder(new EmptyBorder(0, 0, 10, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setPreferredSize(new Dimension(100, 40));
        jPanel2.add((Component)this.pb, "Center");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "South");
        jPanel.add((Component)jScrollPane2, "Center");
        this.add((Component)jPanel, "Center");
    }

    public void debug(String string) {
        this.txtDebugger.append(string + "\n");
        if (this.txtDebugger.getText().length() > 30000) {
            this.txtDebugger.setText(this.txtDebugger.getText().substring(25000));
        }
    }

    public void error(String string) {
        this.txtError.append(string + "\n");
        if (this.txtError.getText().length() > 30000) {
            this.txtError.setText(this.txtError.getText().substring(25000));
        }
    }

    public void clear() {
        this.txtDebugger.setText("");
        this.txtError.setText("");
    }
}

