/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.asemanager;

import com.sysranger.asemanager.ASEManagerGUI;
import com.sysranger.asemanager.ConnectionData;
import com.sysranger.asemanager.Debugger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Properties;

public class ASEManager {
    Connection conn;

    public ASEManager() {
        new ASEManagerGUI(this);
    }

    public boolean connect(ConnectionData connectionData) {
        connectionData.url = "jdbc:sybase:Tds:" + connectionData.host + ":" + connectionData.port;
        if (!connectionData.database.isEmpty()) {
            connectionData.url = connectionData.url + "/" + connectionData.database;
        }
        try {
            Class.forName("com.sybase.jdbc4.jdbc.SybDriver");
            System.out.println("Driver Loaded");
            Debugger.print("Connecting...");
            Properties properties = new Properties();
            properties.put("ENCRYPT_PASSWORD", "true");
            properties.put("user", connectionData.username);
            properties.put("password", connectionData.password);
            this.conn = DriverManager.getConnection(connectionData.url, properties);
            Debugger.print("Connected");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Could not find the JDBC driver!");
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Debugger.print("Cannot connect");
        }
        return false;
    }

    public String safeTableName(String string) {
        try {
            DatabaseMetaData databaseMetaData = this.conn.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, null);
            while (resultSet.next()) {
                String string2 = resultSet.getString("TABLE_NAME");
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return "";
    }

    public static void main(String[] stringArray) {
        new ASEManager();
    }
}

