/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.asemanager;

import com.sysranger.asemanager.ASEManager;
import com.sysranger.asemanager.ConnectionData;
import com.sysranger.asemanager.DatabaseTree;
import com.sysranger.asemanager.Debugger;
import com.sysranger.asemanager.TableNode;
import com.sysranger.asemanager.Utils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.DefaultCaret;

public class ASEManagerGUI
extends JFrame
implements ActionListener {
    public ASEManager manager;
    private JTextField txtHost = new JTextField("");
    private JTextField txtPort = new JTextField("");
    private JTextField txtUserName = new JTextField("");
    private JTextField txtPassword = new JPasswordField("0rk0s0fT-53");
    private JTextField txtDatabase = new JTextField("");
    private JButton buttonConnect = new JButton("Connect");
    private JTextArea txtDebugger = new JTextArea();
    private Properties properties;
    private JLabel labelStatus = new JLabel();
    private DatabaseTree dbTree;
    private JTable table;
    private JTable tableAllTables = new JTable();
    private CardLayout cardLayout = new CardLayout();
    JPanel panelCards = new JPanel(this.cardLayout);
    private JLabel labelError = new JLabel();
    int w = 1000;
    int h = 700;
    private JTable tableFields = new JTable();
    JTextArea txtDatabaseInformation = new JTextArea();

    public ASEManagerGUI(ASEManager aSEManager) {
        super("SysRanger ASE Viewer");
        this.manager = aSEManager;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.out.println("GUI-Unable to set LookAndFeel");
        }
        this.setIcon();
        this.replaceStandartSystemOutPrintStream();
        this.createComponents();
        this.setVisible(true);
        this.setSize(this.w, this.h);
        this.setDefaultCloseOperation(3);
        this.readProperties();
    }

    private void setIcon() {
        try {
            URL uRL = this.getClass().getResource("/images/tray.png");
            if (uRL == null) {
                return;
            }
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            this.setIconImage(image);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel("Host");
        JLabel jLabel2 = new JLabel("Port");
        JLabel jLabel3 = new JLabel("User");
        JLabel jLabel4 = new JLabel("Password");
        JLabel jLabel5 = new JLabel("Database");
        this.txtHost.setPreferredSize(new Dimension(80, 27));
        this.txtPort.setPreferredSize(new Dimension(80, 27));
        this.txtUserName.setPreferredSize(new Dimension(80, 27));
        this.txtPassword.setPreferredSize(new Dimension(80, 27));
        this.txtDatabase.setPreferredSize(new Dimension(80, 27));
        this.buttonConnect.addActionListener(this);
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.addComponent(jPanel, gridBagConstraints, jLabel, 0, 0);
        this.addComponent(jPanel, gridBagConstraints, jLabel2, 1, 0);
        this.addComponent(jPanel, gridBagConstraints, jLabel3, 2, 0);
        this.addComponent(jPanel, gridBagConstraints, jLabel4, 3, 0);
        this.addComponent(jPanel, gridBagConstraints, jLabel5, 4, 0);
        this.addComponent(jPanel, gridBagConstraints, this.txtHost, 0, 1);
        this.addComponent(jPanel, gridBagConstraints, this.txtPort, 1, 1);
        this.addComponent(jPanel, gridBagConstraints, this.txtUserName, 2, 1);
        this.addComponent(jPanel, gridBagConstraints, this.txtPassword, 3, 1);
        this.addComponent(jPanel, gridBagConstraints, this.txtDatabase, 4, 1);
        this.addComponent(jPanel, gridBagConstraints, this.buttonConnect, 5, 1);
        gridBagConstraints.gridwidth = 6;
        this.addComponent(jPanel, gridBagConstraints, this.labelStatus, 0, 2);
        JScrollPane jScrollPane = new JScrollPane(this.txtDebugger, 22, 32);
        ((DefaultCaret)this.txtDebugger.getCaret()).setUpdatePolicy(2);
        jScrollPane.setPreferredSize(new Dimension(this.w, 120));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setBorder(new EmptyBorder(0, 0, 10, 0));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.dbTree = new DatabaseTree(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.dbTree, 22, 30);
        jScrollPane2.setViewportView(this.dbTree);
        this.table = new JTable();
        this.table.setAutoResizeMode(0);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane3 = new JScrollPane(this.table);
        jPanel4.add((Component)jScrollPane3, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)this.labelError, "North");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel6, "Center");
        jPanel6.add(this.tableFields);
        this.labelError.setBorder(new EmptyBorder(10, 10, 30, 10));
        JPanel jPanel7 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane4 = new JScrollPane(this.txtDatabaseInformation);
        jScrollPane4.setPreferredSize(new Dimension(this.w, 120));
        JPanel jPanel8 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane5 = new JScrollPane(this.tableAllTables);
        jPanel8.add((Component)jScrollPane5, "Center");
        jPanel8.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel7.add((Component)jScrollPane4, "North");
        jPanel7.add((Component)jPanel8, "Center");
        this.panelCards.add((Component)jPanel4, "data");
        this.panelCards.add((Component)jPanel5, "error");
        this.panelCards.add((Component)jPanel7, "databaseinformation");
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane2, this.panelCards);
        jSplitPane.setResizeWeight(0.3);
        jPanel3.add((Component)jSplitPane, "Center");
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)jScrollPane, "South");
        jPanel2.add(jPanel3);
        this.add((Component)jPanel2, "Center");
    }

    private void showCard(String string) {
        this.cardLayout.show(this.panelCards, string);
    }

    public void error(String string) {
        this.showCard("error");
        this.labelError.setText(string);
    }

    private void addComponent(JPanel jPanel, GridBagConstraints gridBagConstraints, Component component, int n, int n2) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.insets.right = n > 4 ? 0 : 2;
        jPanel.add(component, gridBagConstraints);
    }

    private void connect() {
        this.clearTable();
        this.dbTree.clear();
        this.repaint();
        ConnectionData connectionData = new ConnectionData();
        connectionData.host = this.txtHost.getText();
        connectionData.port = Utils.toInt(this.txtPort.getText());
        connectionData.password = this.txtPassword.getText();
        connectionData.username = this.txtUserName.getText();
        connectionData.database = this.txtDatabase.getText();
        this.properties.setProperty("host", connectionData.host);
        this.properties.setProperty("port", this.txtPort.getText());
        this.properties.setProperty("user", connectionData.username);
        this.properties.setProperty("database", connectionData.database);
        this.saveProperties();
        boolean bl = this.manager.connect(connectionData);
        if (bl) {
            this.dbTree.showData();
        } else {
            this.error("Cannot connect");
        }
    }

    public void showAllTables(DefaultTableModel defaultTableModel) {
        this.tableAllTables.setModel(defaultTableModel);
        this.showDatabaseInformation();
        this.showCard("databaseinformation");
    }

    public void clearTable() {
        this.table.setModel(new DefaultTableModel());
    }

    private void showDatabaseInformation() {
        this.txtDatabaseInformation.setText("");
        Connection connection = this.manager.conn;
        if (connection == null) {
            return;
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.txtDatabaseInformation.append("Database:" + databaseMetaData.getDatabaseProductName() + "  " + databaseMetaData.getDatabaseMajorVersion() + "." + databaseMetaData.getDatabaseMinorVersion() + "\n");
            this.txtDatabaseInformation.append("Driver:" + databaseMetaData.getDriverName() + "  " + databaseMetaData.getDriverMajorVersion() + "." + databaseMetaData.getDriverMinorVersion() + "\n");
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void showTable(TableNode tableNode) {
        String string = tableNode.name;
        String string2 = "\"" + tableNode.database + "." + tableNode.schema + "." + string + "\"";
        String string3 = "select top 100 * from " + string2 + " ";
        Debugger.print(string3);
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        try {
            Object object;
            int n;
            PreparedStatement preparedStatement = this.manager.conn.prepareStatement(string3);
            ResultSet resultSet = preparedStatement.executeQuery();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
                defaultTableModel.addColumn(resultSetMetaData.getColumnLabel(n + 1));
            }
            while (resultSet.next()) {
                Vector<String> vector = new Vector<String>();
                for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                    object = resultSet.getObject(n);
                    String string4 = "";
                    string4 = object == null ? "" : object.toString();
                    vector.add(string4);
                }
                defaultTableModel.addRow(vector);
            }
            this.table.setModel(defaultTableModel);
            int n2 = this.table.getColumnModel().getColumnCount();
            for (n = 0; n < n2; ++n) {
                object = this.table.getColumnModel().getColumn(n);
                ((TableColumn)object).setWidth(100);
                ((TableColumn)object).setPreferredWidth(100);
                ((TableColumn)object).setMinWidth(100);
            }
            this.showCard("data");
        }
        catch (SQLException sQLException) {
            Debugger.print(sQLException.getMessage());
            this.error(sQLException.getMessage());
            this.showFields(tableNode);
        }
    }

    private void showFields(TableNode tableNode) {
        Connection connection = this.manager.conn;
        if (connection == null) {
            this.tableFields.setModel(new DefaultTableModel());
            return;
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{"Column", "Type", "Size"}, 0);
            ResultSet resultSet = databaseMetaData.getColumns(tableNode.database, tableNode.schema, tableNode.name, null);
            while (resultSet.next()) {
                String string = resultSet.getString("COLUMN_NAME");
                String string2 = resultSet.getString("TYPE_NAME");
                int n = resultSet.getInt("COLUMN_SIZE");
                defaultTableModel.addRow(new String[]{string, string2, n + ""});
            }
            this.tableFields.setModel(defaultTableModel);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.tableFields.setModel(new DefaultTableModel());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonConnect) {
            this.connect();
            return;
        }
    }

    public void debug(String string, boolean bl) {
        this.txtDebugger.append(string + "\n");
        if (this.txtDebugger.getText().length() > 10000) {
            this.txtDebugger.setText(this.txtDebugger.getText().substring(5000));
        }
        if (!bl) {
            this.labelStatus.setText(string);
        }
    }

    private boolean readProperties() {
        this.properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream("config.ini");){
            this.properties.load(fileInputStream);
            String string = this.properties.getProperty("host");
            String string2 = this.properties.getProperty("port");
            String string3 = this.properties.getProperty("user");
            String string4 = this.properties.getProperty("database");
            this.txtHost.setText(string);
            this.txtPort.setText(string2);
            this.txtUserName.setText(string3);
            this.txtDatabase.setText(string4);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean saveProperties() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("config.ini");
            this.properties.store(fileOutputStream, null);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private void replaceStandartSystemOutPrintStream() {
        System.setOut(new PrintStream(System.out){

            @Override
            public void print(String string) {
                super.print(string);
                ASEManagerGUI.this.debug(string, false);
            }
        });
        System.setErr(new PrintStream(System.err){

            @Override
            public void print(String string) {
                super.print(string);
                ASEManagerGUI.this.debug(string, true);
            }
        });
    }
}

