/*
 * Decompiled with CFR 0.152.
 */
package com.sysranger.asemanager;

import com.sysranger.asemanager.ASEManager;
import com.sysranger.asemanager.ASEManagerGUI;
import com.sysranger.asemanager.DatabaseNode;
import com.sysranger.asemanager.SRNode;
import com.sysranger.asemanager.SchemaNode;
import com.sysranger.asemanager.TableNode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

public class DatabaseTree
extends JTree
implements TreeSelectionListener {
    ASEManagerGUI gui;
    ASEManager manager;
    DefaultTreeModel defaultModel;
    DefaultTableModel tableModel;

    public DatabaseTree(ASEManagerGUI aSEManagerGUI) {
        this.gui = aSEManagerGUI;
        this.manager = aSEManagerGUI.manager;
        this.addTreeSelectionListener(this);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new DatabaseNode("Database Tree"));
        this.defaultModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.setModel(this.defaultModel);
    }

    public void showData() {
        Connection connection = this.manager.conn;
        if (connection == null) {
            this.clear();
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new DatabaseNode("Databases"));
        try {
            Object object;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getCatalogs();
            this.tableModel = new DefaultTableModel(new String[]{"Database", "Schema", "Table", "Type"}, 0);
            while (resultSet.next()) {
                Object object2;
                Object object3;
                Object object4;
                object = resultSet.getString(1);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DatabaseNode((String)object));
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                ResultSet resultSet2 = databaseMetaData.getTables((String)object, null, null, null);
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                while (resultSet2.next()) {
                    String string = resultSet2.getString("TABLE_SCHEM");
                    String string2 = resultSet2.getString("TABLE_NAME");
                    object4 = resultSet2.getString("TABLE_TYPE");
                    this.tableModel.addRow(new Object[]{object, string, string2, object4});
                    if (hashMap.containsKey(string)) {
                        object3 = (SchemaNode)hashMap.get(string);
                    } else {
                        object3 = new SchemaNode(string);
                        hashMap.put(string, object3);
                    }
                    object2 = new TableNode(string2);
                    ((TableNode)object2).database = object;
                    ((TableNode)object2).schema = string;
                    if (((String)object4).equalsIgnoreCase("TABLE")) {
                        ((SchemaNode)object3).tables.add((TableNode)object2);
                        continue;
                    }
                    if (((String)object4).equalsIgnoreCase("VIEW")) {
                        ((SchemaNode)object3).views.add((TableNode)object2);
                        continue;
                    }
                    if (!((String)object4).equalsIgnoreCase("SYSTEM")) continue;
                    ((SchemaNode)object3).systems.add((TableNode)object2);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    object4 = (SchemaNode)entry.getValue();
                    object3 = new DefaultMutableTreeNode(object4);
                    defaultMutableTreeNode2.add((MutableTreeNode)object3);
                    if (((SchemaNode)object4).tables.size() > 0) {
                        object2 = new DefaultMutableTreeNode(new SRNode("Tables"));
                        ((DefaultMutableTreeNode)object3).add((MutableTreeNode)object2);
                        for (TableNode tableNode : ((SchemaNode)object4).tables) {
                            ((DefaultMutableTreeNode)object2).add(tableNode.treeNode);
                        }
                    }
                    if (((SchemaNode)object4).systems.size() > 0) {
                        object2 = new DefaultMutableTreeNode(new SRNode("System Tables"));
                        ((DefaultMutableTreeNode)object3).add((MutableTreeNode)object2);
                        for (TableNode tableNode : ((SchemaNode)object4).systems) {
                            ((DefaultMutableTreeNode)object2).add(tableNode.treeNode);
                        }
                    }
                    if (((SchemaNode)object4).views.size() <= 0) continue;
                    object2 = new DefaultMutableTreeNode(new SRNode("Views"));
                    ((DefaultMutableTreeNode)object3).add((MutableTreeNode)object2);
                    for (TableNode tableNode : ((SchemaNode)object4).views) {
                        ((DefaultMutableTreeNode)object2).add(tableNode.treeNode);
                    }
                }
            }
            object = new DefaultTreeModel(defaultMutableTreeNode);
            this.setModel((TreeModel)object);
            this.gui.showAllTables(this.tableModel);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.clear();
        }
    }

    public void clear() {
        this.setModel(this.defaultModel);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (defaultMutableTreeNode.toString().equals("Databases")) {
            this.gui.showAllTables(this.tableModel);
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (!(object instanceof TableNode)) {
            return;
        }
        TableNode tableNode = (TableNode)object;
        this.gui.showTable(tableNode);
    }
}

