/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.DES;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.SecureStoreKey;
import com.sybase.jdbc4.jdbc.SecureStoreLoginInformation;
import com.sybase.jdbc4.jdbc.SecureStoreRecord;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.zip.CRC32;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class SecureStore {
    private static final String UTF8_CHARSET = "UTF-8";
    private static final String NAMESPACE = ".ase";
    private static final String KEYFILE = "SSFS_ASE.KEY";
    private static final String DATAFILE = "SSFS_ASE.DAT";
    private static final int MIN_RECORD_LENGTH = 176;
    private static final int ENCRYPTED_RECORD_LENGTH_MULTIPLE = 128;
    private static final char[] DEFAULT_KEY = new char[24];
    private static final char[] FALLBACK_KEK = new char[]{'\u009f', '`', '\u00a6', '\u00dd', '~', '\u0015', '}', '\u0007', '\f', '\u00c3', 'W', '\u0090', '\u009a', '\u00a2', '\u0090', '\u00e9', '6', '\u000e', '\u00ee', 'G', '/', '\u00da', 'G', 'r'};
    private static final int PREAMBLE_LENGTH = 12;
    private static final int RECORD_LENGTH_VALUES_START = 12;
    private static final int RECORD_LENGTH_VALUES_SIZE = 4;
    private static final int RECORD_TYPE_POS = 16;
    private static final int RECORD_IDENTIFIER_START = 24;
    private static final int RECORD_IDENTIFIER_LENGTH = 64;
    private static final int TIMESTAMP_START = 88;
    private static final int TIMESTAMP_LENGTH = 8;
    private static final int USERNAME_START = 96;
    private static final int USERNAME_LENGTH = 24;
    private static final int HOSTNAME_START = 120;
    private static final int HOSTNAME_LENGTH = 24;
    private static final int IS_DELETED_FLAG_POS = 144;
    private static final int IS_PLAINTEXT_FLAG_POS = 145;
    private static final int IS_BINARY_FLAG_POS = 146;
    private static final int HMAC_START = 156;
    private static final int HMAC_LENGTH = 20;
    private static final int DATA_LENGTH_FOR_HMAC = 132;
    private static final int SHA1_LENGTH = 20;
    private static final int DATA_ENCRYPTED_PART1_LENGTH = 12;
    private static final int DATA_ENCRYPTED_PART2_LENGTH = 96;
    private static final int PAYLOAD_LENGTH = 4;
    private static final int PAYLOAD_DATA_START = 32;
    private static final int RANDOM_CONTENT_LENGTH = 8;
    private static final int KEY_PREAMBLE_START = 0;
    private static final int KEY_PREAMBLE_LENGTH = 11;
    private static final int KEY_TYPE_POS = 11;
    private static final int KEY_USERNAME_START = 20;
    private static final int KEY_HOSTNAME_START = 44;
    private static final int KEY_HMAC_START = 106;
    private static final int KEY_CRC32_START = 126;
    private static final int KEY_CRC32_LENGTH = 4;
    private static final int KEY_EK_LENGTH = 24;
    private static final int KEY_ENCRYPTED_DATA_START = 130;
    private static final int KEY_ENCRYPTED_DATA_LENGTH = 57;
    private static final int KEY_DATA_PART1_LENGTH = 106;
    private static final int KEY_DATA_PART2_LENGTH = 57;

    private SecureStore() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    protected static SecureStoreLoginInformation getLoginInformation(String string) throws SQLException {
        Map<String, SecureStoreRecord> map = null;
        if (string == null || string.trim().isEmpty()) {
            ErrorMessage.raiseError("JZSNK");
        }
        string = string.toUpperCase(Locale.ENGLISH);
        String string2 = "/";
        String string3 = "ASE" + string2 + string + string2;
        String string4 = string3 + "DB_USER";
        String string5 = string3 + "DB_PASSWORD";
        String string6 = string3 + "DB_CON_ENV";
        String string7 = string3 + "DB_DATABASE_NAME";
        String string8 = System.getProperty("user.home");
        String string9 = null;
        try {
            string9 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string9 = "localhost";
        }
        String string10 = string8 + File.separator + NAMESPACE + File.separator + string9 + File.separator + KEYFILE;
        String string11 = string8 + File.separator + NAMESPACE + File.separator + string9 + File.separator + DATAFILE;
        if (!SecureStore.checkFile(string10) || !SecureStore.checkFile(string11)) {
            ErrorMessage.raiseError("JZSIF");
        }
        map = SecureStore.readDataFile(string11);
        SecureStoreKey secureStoreKey = SecureStore.readKeyFile(string10);
        SecureStoreRecord secureStoreRecord = map.get(string4);
        SecureStoreRecord secureStoreRecord2 = map.get(string5);
        SecureStoreRecord secureStoreRecord3 = map.get(string6);
        SecureStoreRecord secureStoreRecord4 = map.get(string7);
        String string12 = null;
        String string13 = null;
        char[] cArray = null;
        String string14 = null;
        SecureStore.warnOnMissingKey(secureStoreRecord);
        string13 = String.valueOf(secureStoreRecord.getData());
        if (string13.equals("")) {
            ErrorMessage.raiseError("JZSMK");
        }
        if (secureStoreRecord2 != null) {
            cArray = SecureStore.getSecureStorePwd(secureStoreRecord2, secureStoreKey);
        }
        if (secureStoreRecord3 != null) {
            string14 = String.valueOf(secureStoreRecord3.getData());
        }
        if (secureStoreRecord4 != null) {
            string12 = String.valueOf(secureStoreRecord4.getData());
        }
        SecureStoreLoginInformation secureStoreLoginInformation = new SecureStoreLoginInformation(string13, cArray, string14, string12);
        return secureStoreLoginInformation;
    }

    private static void warnOnMissingKey(SecureStoreRecord secureStoreRecord) throws SQLException {
        if (secureStoreRecord == null) {
            ErrorMessage.raiseError("JZSMK");
        }
    }

    private static boolean checkFile(String string) throws SQLException {
        try {
            File file = new File(string);
            if (!file.exists()) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static char[] getSecureStorePwd(SecureStoreRecord secureStoreRecord, SecureStoreKey secureStoreKey) throws SQLException {
        char[] cArray = secureStoreKey.getKey();
        char[] cArray2 = secureStoreRecord.getData();
        DES.RSecPDecrypt(cArray, cArray2, cArray2.length);
        if (cArray2.length == 0 || cArray2.length % 128 != 0) {
            ErrorMessage.raiseError("JZSIF");
        }
        if (!SecureStore.checkSha1EncryptedRecord(cArray2)) {
            ErrorMessage.raiseError("JZSIF");
        }
        char[] cArray3 = new char[4];
        for (int i = 0; i < 4; ++i) {
            cArray3[i] = cArray2[i + 8];
        }
        int n = SecureStore.getRecordLength(cArray3);
        char[] cArray4 = new char[n];
        System.arraycopy(cArray2, 32, cArray4, 0, n);
        Arrays.fill(cArray2, '\u0000');
        return cArray4;
    }

    private static boolean checkSha1EncryptedRecord(char[] cArray) throws SQLException {
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        byte[] byArray2 = new byte[cArray.length - 20];
        System.arraycopy(byArray, 0, byArray2, 0, 12);
        System.arraycopy(byArray, 32, byArray2, 12, 96);
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ErrorMessage.raiseError("JZSGN");
        }
        byte[] byArray3 = messageDigest.digest(byArray2);
        for (int i = 0; i < 20; ++i) {
            if (byArray3[i] == byArray[i + 12]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readFile(File file, byte[] byArray) throws SQLException {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            if (randomAccessFile.read(byArray) == -1) {
                ErrorMessage.raiseError("JZSIF");
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseError("JZSIF");
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void getBytesInChar(byte[] byArray, char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)byArray[i + n];
        }
    }

    private static Map<String, SecureStoreRecord> readDataFile(String string) throws SQLException {
        File file = new File(string);
        byte[] byArray = new byte[(int)file.length()];
        HashMap<String, SecureStoreRecord> hashMap = new HashMap<String, SecureStoreRecord>();
        SecureStore.readFile(file, byArray);
        if (byArray.length < 176) {
            ErrorMessage.raiseError("JZSIF");
        }
        int n = 0;
        while (n < byArray.length) {
            try {
                String string2 = new String(byArray, n, 12, UTF8_CHARSET).trim();
                char[] cArray = new char[4];
                SecureStore.getBytesInChar(byArray, cArray, n + 12, 4);
                int n2 = SecureStore.getRecordLength(cArray);
                byte by = byArray[n + 16];
                if (!SecureStore.checkDataFile(string2, by, n2)) {
                    ErrorMessage.raiseError("JZSIF");
                }
                String string3 = new String(byArray, n + 24, 64, UTF8_CHARSET);
                byte[] byArray2 = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    byArray2[i] = byArray[n + i + 88];
                }
                String string4 = new String(byArray, n + 96, 24, UTF8_CHARSET);
                String string5 = new String(byArray, n + 120, 24, UTF8_CHARSET);
                byte by2 = byArray[n + 144];
                byte by3 = byArray[n + 145];
                byte by4 = byArray[n + 146];
                byte[] byArray3 = new byte[20];
                System.arraycopy(byArray, n + 156, byArray3, 0, byArray3.length);
                char[] cArray2 = null;
                if (by2 != 1) {
                    int n3;
                    if (by3 == 1 || by4 == 1) {
                        cArray2 = new String(byArray, n + 176, n2 - 176, UTF8_CHARSET).toCharArray();
                    } else {
                        cArray2 = new char[n2 - 176];
                        n3 = n2 - 176;
                        if (n3 % 128 != 0) {
                            ErrorMessage.raiseError("JZSIF");
                        }
                        int n4 = 0;
                        while (n3 > 0) {
                            cArray2[n4] = (char)byArray[n + 176 + n4];
                            --n3;
                            ++n4;
                        }
                    }
                    if (!SecureStore.checkHMAC(byArray3, byArray, n, cArray2)) {
                        ErrorMessage.raiseError("JZSIF");
                    }
                    n3 = n2 - 176;
                    SecureStoreRecord secureStoreRecord = new SecureStoreRecord(string2, byArray2, string4, string5, by, n2, string3, by2, by3, by4, byArray3, n3, cArray2);
                    hashMap.put(string3.trim(), secureStoreRecord);
                }
                n += n2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ErrorMessage.raiseError("JZSGN");
            }
        }
        return hashMap;
    }

    private static boolean checkDataFile(String string, int n, int n2) {
        return string.equals("RSecSSFsData") && n == 1 && n2 >= 176 && n2 <= 98640;
    }

    private static boolean checkHMAC(byte[] byArray, byte[] byArray2, int n, char[] cArray) throws SQLException {
        int n2;
        char[] cArray2 = new char[]{'\u0003', 'A', '\u0005', 'W', '\u0017', '\u00c4', '\u0017', 'A', ',', '`', '[', 'z', '\u00d5', '\u0005', '\u00f3', '\u0003'};
        byte[] byArray3 = new byte[cArray2.length];
        byte[] byArray4 = new byte[132 + cArray.length];
        System.arraycopy(byArray2, n + 24, byArray4, 0, 132);
        for (n2 = 0; n2 < cArray.length; ++n2) {
            byArray4[132 + n2] = (byte)cArray[n2];
        }
        DES.rsecedv1_encode_default_v1(cArray2, cArray2.length);
        for (n2 = 0; n2 < cArray2.length; ++n2) {
            byArray3[n2] = (byte)cArray2[n2];
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, "HmacSHA1");
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ErrorMessage.raiseError("JZSGN");
        }
        catch (InvalidKeyException invalidKeyException) {
            ErrorMessage.raiseError("JZSGN");
        }
        byte[] byArray5 = mac.doFinal(byArray4);
        for (int i = 0; i < byArray5.length; ++i) {
            if (byArray5[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    private static int getRecordLength(char[] cArray) {
        return cArray[0] << 24 | (cArray[1] & 0xFF) << 16 | (cArray[2] & 0xFF) << 8 | cArray[3] & 0xFF;
    }

    private static SecureStoreKey readKeyFile(String string) throws SQLException {
        File file = new File(string);
        byte[] byArray = new byte[(int)file.length()];
        SecureStore.readFile(file, byArray);
        char[] cArray = new char[24];
        try {
            String string2 = new String(byArray, 0, 11, UTF8_CHARSET);
            byte by = byArray[11];
            if (!SecureStore._checkKeyFile(string2, by)) {
                ErrorMessage.raiseError("JZSIF");
            }
            String string3 = new String(byArray, 20, 24, UTF8_CHARSET).trim();
            String string4 = new String(byArray, 44, 24, UTF8_CHARSET).trim();
            byte[] byArray2 = new byte[20];
            System.arraycopy(byArray, 106, byArray2, 0, 20);
            boolean bl = SecureStore.checkHMACKey(byArray2, byArray);
            if (!bl) {
                ErrorMessage.raiseError("JZSIF");
            }
            byte[] byArray3 = new byte[4];
            System.arraycopy(byArray, 126, byArray3, 0, 4);
            bl = SecureStore.verifyCRC32(byArray, byArray3);
            if (!bl) {
                ErrorMessage.raiseError("JZSIF");
            }
            char[] cArray2 = new char[57];
            cArray2 = new String(byArray, 130, 57, "ISO-8859-1").toCharArray();
            DES.RSecPDecrypt(FALLBACK_KEK, cArray2, cArray2.length);
            System.arraycopy(cArray2, 33, cArray, 0, 24);
            SecureStoreKey secureStoreKey = new SecureStoreKey(string2, string3, string4, by, cArray);
            return secureStoreKey;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SecureStoreKey secureStoreKey = new SecureStoreKey("", "", "", 1, DEFAULT_KEY);
            return secureStoreKey;
        }
    }

    private static boolean checkHMACKey(byte[] byArray, byte[] byArray2) throws SQLException {
        int n;
        char[] cArray = new char[]{'\u009f', '`', '\u00a6', '\u00dd', '~', '\u0015', '}', '\u0007', '\f', '\u00c3', 'W', '\u0090', '\u009a', '\u00a2', '\u0090', '\u00e9', '6', '\u000e', '\u00ee', 'G', '/', '\u00da', 'G', 'r'};
        byte[] byArray3 = new byte[cArray.length];
        byte[] byArray4 = new byte[163];
        System.arraycopy(byArray2, 0, byArray4, 0, 106);
        System.arraycopy(byArray2, 130, byArray4, 106, 57);
        for (n = 0; n < cArray.length; ++n) {
            byArray3[n] = (byte)cArray[n];
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray3, "HmacSHA1");
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            ErrorMessage.raiseError("JZSGN");
        }
        catch (InvalidKeyException invalidKeyException) {
            ErrorMessage.raiseError("JZSGN");
        }
        byte[] byArray5 = mac.doFinal(byArray4);
        for (n = 0; n < byArray5.length; ++n) {
            if (byArray5[n] == byArray[n]) continue;
            return false;
        }
        return true;
    }

    private static boolean verifyCRC32(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[183];
        System.arraycopy(byArray, 0, byArray3, 0, 126);
        System.arraycopy(byArray, 130, byArray3, 126, 57);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray3);
        return cRC32.getValue() == ((long)ByteBuffer.wrap(byArray2).order(ByteOrder.BIG_ENDIAN).getInt() & 0xFFFFFFFFL);
    }

    private static boolean _checkKeyFile(String string, int n) {
        return string.equals("RSecSSFsKey") && n == 2;
    }
}

