/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.LobClientInputStream;
import com.sybase.jdbc4.jdbc.LobClientOutputStream;
import com.sybase.jdbc4.jdbc.LobClientReader;
import com.sybase.jdbc4.jdbc.LobClientWriter;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.utils.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class SybCharClientLob
extends SybLob
implements NClob {
    private static final Logger LOG = Logger.getLogger(SybCharClientLob.class.getName());
    private static volatile long _logIdCounter = 0L;
    private AtomicLong _apiCount = new AtomicLong(0L);
    private StringBuilder data;

    public SybCharClientLob(String string, ProtocolContext protocolContext, StringBuilder stringBuilder, SybLob.LOB_TYPE lOB_TYPE) throws SQLException {
        this.data = stringBuilder;
        this._lobType = lOB_TYPE;
        this._logId = string + "_Cc" + _logIdCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkClientLOBValidity();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new LobClientInputStream(this, 1L, this.length()), 16384);
            return bufferedInputStream;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getAsciiStream", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkClientLOBValidity();
            BufferedReader bufferedReader = new BufferedReader(new LobClientReader(this, 1L, this.length()), 16384);
            return bufferedReader;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        BufferedReader bufferedReader;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l3 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l3);
                }
                this.checkClientLOBValidity();
                long l4 = this.length();
                if (l < 1L || l > l4 || l + l2 > l4) {
                    ErrorMessage.raiseError("JZ037");
                }
                bufferedReader = new BufferedReader(new LobClientReader(this, l, l2), 16384);
                if (!bl) break block5;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", "long, long", new Object[]{l, l2}, l3);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "getCharacterStream", "long, long", new Object[]{l, l2}, l3);
        }
        return bufferedReader;
    }

    public StringBuilder getDataRef() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubString(long l, int n) throws SQLException {
        String string;
        block14: {
            long l2;
            long l3;
            boolean bl;
            block12: {
                String string2;
                block13: {
                    block10: {
                        String string3;
                        block11: {
                            bl = LogUtil.isLoggingEnabled(LOG);
                            l3 = bl ? this._apiCount.incrementAndGet() : 0L;
                            try {
                                if (bl) {
                                    LogUtil.logBegin(LOG, this._logId, l3);
                                }
                                this.checkClientLOBValidity();
                                if (l < 1L) {
                                    ErrorMessage.raiseError("JZ037");
                                } else if (n < 0) {
                                    ErrorMessage.raiseError("JZ038");
                                }
                                l2 = this.length();
                                if (this.data != null && l <= l2) break block10;
                                string3 = null;
                                if (!bl) break block11;
                            }
                            catch (Throwable throwable) {
                                if (bl) {
                                    LogUtil.logEnd(LOG, null, null, this._logId, "getSubString", "long, int", new Object[]{l, n}, l3);
                                }
                                throw throwable;
                            }
                            LogUtil.logEnd(LOG, null, null, this._logId, "getSubString", "long, int", new Object[]{l, n}, l3);
                        }
                        return string3;
                    }
                    if (n != 0) break block12;
                    string2 = "";
                    if (!bl) break block13;
                    LogUtil.logEnd(LOG, null, null, this._logId, "getSubString", "long, int", new Object[]{l, n}, l3);
                }
                return string2;
            }
            if (l + (long)n - 1L > l2) {
                n = (int)(l2 - l + 1L);
            }
            string = this.data.substring((int)l - 1, (int)l + n - 1);
            if (!bl) break block14;
            LogUtil.logEnd(LOG, null, null, this._logId, "getSubString", "long, int", new Object[]{l, n}, l3);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(String string, long l) throws SQLException {
        long l2;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l3 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                int n;
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l3);
                }
                this.checkClientLOBValidity();
                if (l < 1L) {
                    ErrorMessage.raiseError("JZ037");
                }
                n = (n = this.data.indexOf(string, (int)l - 1)) < 0 ? n : n + 1;
                l2 = n;
                if (!bl) break block5;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "position", "String, long", new Object[]{string, l}, l3);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "position", "String, long", new Object[]{string, l}, l3);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(Clob clob, long l) throws SQLException {
        long l2;
        block7: {
            long l3;
            boolean bl;
            block5: {
                long l4;
                block6: {
                    bl = LogUtil.isLoggingEnabled(LOG);
                    l3 = bl ? this._apiCount.incrementAndGet() : 0L;
                    try {
                        if (bl) {
                            LogUtil.logBegin(LOG, this._logId, l3);
                        }
                        this.checkClientLOBValidity();
                        if (clob != null && this.data != null) break block5;
                        l4 = -1L;
                        if (!bl) break block6;
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            LogUtil.logEnd(LOG, null, null, this._logId, "position", "Clob, long", new Object[]{clob, l}, l3);
                        }
                        throw throwable;
                    }
                    LogUtil.logEnd(LOG, null, null, this._logId, "position", "Clob, long", new Object[]{clob, l}, l3);
                }
                return l4;
            }
            l2 = this.position(((SybCharClientLob)clob).getString(), l);
            if (!bl) break block7;
            LogUtil.logEnd(LOG, null, null, this._logId, "position", "Clob, long", new Object[]{clob, l}, l3);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long l, String string) throws SQLException {
        int n;
        block10: {
            long l2;
            boolean bl;
            block8: {
                int n2;
                block9: {
                    bl = LogUtil.isLoggingEnabled(LOG);
                    l2 = bl ? this._apiCount.incrementAndGet() : 0L;
                    try {
                        if (bl) {
                            LogUtil.logBegin(LOG, this._logId, l2);
                        }
                        this.checkClientLOBValidity();
                        if (l < 1L) {
                            ErrorMessage.raiseError("JZ037");
                        }
                        if (string == null) break block8;
                        long l3 = this.length();
                        if (l3 > 0L && l > l3 + 1L) {
                            ErrorMessage.raiseError("JZ037");
                        }
                        if (this.data != null) {
                            this.data.replace((int)l - 1, (int)l + string.length() - 1, string);
                        }
                        n2 = string.length();
                        if (!bl) break block9;
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            LogUtil.logEnd(LOG, null, null, this._logId, "setString", "long, String", new Object[]{l, string}, l2);
                        }
                        throw throwable;
                    }
                    LogUtil.logEnd(LOG, null, null, this._logId, "setString", "long, String", new Object[]{l, string}, l2);
                }
                return n2;
            }
            n = 0;
            if (!bl) break block10;
            LogUtil.logEnd(LOG, null, null, this._logId, "setString", "long, String", new Object[]{l, string}, l2);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        int n3;
        block8: {
            long l2;
            boolean bl;
            block6: {
                int n4;
                block7: {
                    bl = LogUtil.isLoggingEnabled(LOG);
                    l2 = bl ? this._apiCount.incrementAndGet() : 0L;
                    try {
                        if (bl) {
                            LogUtil.logBegin(LOG, this._logId, l2);
                        }
                        this.checkClientLOBValidity();
                        if (l < 1L) {
                            ErrorMessage.raiseError("JZ037");
                        }
                        if (string == null) break block6;
                        n4 = this.setString(l, string.substring(n - 1, n - 1 + n2));
                        if (!bl) break block7;
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            LogUtil.logEnd(LOG, null, null, this._logId, "setString", "long, String, int, int", new Object[]{l, string, n, n2}, l2);
                        }
                        throw throwable;
                    }
                    LogUtil.logEnd(LOG, null, null, this._logId, "setString", "long, String, int, int", new Object[]{l, string, n, n2}, l2);
                }
                return n4;
            }
            n3 = 0;
            if (!bl) break block8;
            LogUtil.logEnd(LOG, null, null, this._logId, "setString", "long, String, int, int", new Object[]{l, string, n, n2}, l2);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        BufferedOutputStream bufferedOutputStream;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l2);
                }
                this.checkClientLOBValidity();
                if (l < 1L || l > this.length()) {
                    ErrorMessage.raiseError("JZ037");
                }
                bufferedOutputStream = new BufferedOutputStream(new LobClientOutputStream(this, l), 16384);
                if (!bl) break block5;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "long", new Object[]{l}, l2);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "setAsciiStream", "long", new Object[]{l}, l2);
        }
        return bufferedOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        BufferedWriter bufferedWriter;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l2);
                }
                this.checkClientLOBValidity();
                if (l < 1L || l > this.length()) {
                    ErrorMessage.raiseError("JZ037");
                }
                bufferedWriter = new BufferedWriter(new LobClientWriter(this, l), 16384);
                if (!bl) break block5;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "long", new Object[]{l}, l2);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "setCharacterStream", "long", new Object[]{l}, l2);
        }
        return bufferedWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkClientLOBValidity();
            if (this.data != null) {
                String string = this.data.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getString", null, null, l);
            }
        }
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (!this._freeCalled) {
                this.data = null;
                this._freeCalled = true;
            }
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "free", null, null, l);
            }
        }
    }

    private void checkClientLOBValidity() throws SQLException {
        if (this._freeCalled) {
            ErrorMessage.raiseError("JZ036");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkClientLOBValidity();
            byte[] byArray = this.data.toString().getBytes();
            return byArray;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getBytes", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void truncate(long l) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l2 = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l2);
            }
            this.checkClientLOBValidity();
            if (l < 0L) {
                ErrorMessage.raiseError("JZ038");
            }
            this.data.setLength((int)l);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "truncate", "long", new Object[]{l}, l2);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "truncate", "long", new Object[]{l}, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkClientLOBValidity();
            if (this.data == null) {
                long l2 = 0L;
                return l2;
            }
            long l3 = this.data.length();
            return l3;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "length", null, null, l);
            }
        }
    }
}

