/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.SybCallableStatement;
import com.sybase.jdbc4.jdbc.SybCallableStatementProxy;
import com.sybase.jdbc4.jdbc.SybPooledConnection;
import com.sybase.jdbc4.jdbc.SybPreparedStatement;
import com.sybase.jdbc4.jdbc.SybPreparedStatementProxy;
import com.sybase.jdbc4.jdbc.SybStatement;
import com.sybase.jdbc4.jdbc.SybXAConnection;
import com.sybase.jdbc4.jdbc.SybXAResource;
import com.sybase.jdbc4.jdbc.SybXAResource11;
import com.sybase.jdbcx.Capture;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybEventHandler;
import com.sybase.jdbcx.SybMessageHandler;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.sql.XAConnection;

public class SybConnectionProxy
implements SybConnection {
    protected final SybPooledConnection _realConn;
    private final boolean _realConnIsXA;
    private Vector<Statement> _openStatements = new Vector();
    private Vector<SybPreparedStatementProxy> _openPreparedStatements = new Vector();
    private Vector<SybCallableStatementProxy> _openCallableStatements = new Vector();
    private boolean _wasClosed = false;

    public SybConnectionProxy(SybPooledConnection sybPooledConnection) {
        this._realConn = sybPooledConnection;
        this._realConnIsXA = this._realConn instanceof XAConnection;
    }

    @Override
    public void close() throws SQLException {
        this.checkIfClosed();
        this._wasClosed = true;
        this.closeRememberedStatements();
        this.closeRememberedPreparedStatements();
        this.closeRememberedCallableStatements();
        this._realConn.notifyConnectionListeners();
    }

    @Override
    public void commit() throws SQLException {
        this.checkIfClosed();
        if (this._realConnIsXA && !this.checkLocalTransaction("commit()")) {
            return;
        }
        try {
            this._realConn.commit();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkIfClosed();
        if (this._realConnIsXA && !this.checkLocalTransaction("rollback()")) {
            return;
        }
        try {
            this._realConn.rollback();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkIfClosed();
        if (this._realConnIsXA && !this.checkLocalTransaction("rollback(Savepoint)")) {
            return;
        }
        try {
            this._realConn.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkIfClosed();
        if (this._realConnIsXA && !this.checkLocalTransaction("setSavepoint()")) {
            return null;
        }
        try {
            return this._realConn.setSavepoint();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        this.checkIfClosed();
        if (this._realConnIsXA && !this.checkLocalTransaction("setSavepoint(String)")) {
            return null;
        }
        try {
            return this._realConn.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkIfClosed();
        if (this._realConnIsXA && !this.checkLocalTransaction("releaseSavepoint(Savepoint)")) {
            return;
        }
        try {
            this._realConn.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getHoldability();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setHoldability(n);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkIfClosed();
        if (this._realConnIsXA && bl && this._realConnIsXA && !this.checkLocalTransaction("setAutoCommit()")) {
            return;
        }
        try {
            this._realConn.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkIfClosed();
        Statement statement = null;
        try {
            statement = this._realConn.createStatement();
            this.rememberStatement(statement);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return statement;
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkIfClosed();
        Statement statement = null;
        try {
            statement = this._realConn.createStatement(n, n2);
            this.rememberStatement(statement);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return statement;
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkIfClosed();
        Statement statement = null;
        try {
            statement = this._realConn.createStatement(n, n2, n3);
            this.rememberStatement(statement);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return statement;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getCatalog();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getMetaData();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getWarnings();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this._wasClosed) {
            return true;
        }
        try {
            return this._realConn.isClosed();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkIfClosed();
        SybCallableStatementProxy sybCallableStatementProxy = null;
        try {
            SybCallableStatement sybCallableStatement = (SybCallableStatement)this._realConn.prepareCall(string);
            sybCallableStatementProxy = new SybCallableStatementProxy(sybCallableStatement, this._realConn);
            this.rememberCallableStatements(sybCallableStatementProxy);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return sybCallableStatementProxy;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkIfClosed();
        SybCallableStatementProxy sybCallableStatementProxy = null;
        try {
            SybCallableStatement sybCallableStatement = (SybCallableStatement)this._realConn.prepareCall(string, n, n2);
            sybCallableStatementProxy = new SybCallableStatementProxy(sybCallableStatement, this._realConn);
            this.rememberCallableStatements(sybCallableStatementProxy);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return sybCallableStatementProxy;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkIfClosed();
        SybCallableStatementProxy sybCallableStatementProxy = null;
        try {
            SybCallableStatement sybCallableStatement = (SybCallableStatement)this._realConn.prepareCall(string, n, n2, n3);
            sybCallableStatementProxy = new SybCallableStatementProxy(sybCallableStatement, this._realConn);
            this.rememberCallableStatements(sybCallableStatementProxy);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return sybCallableStatementProxy;
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkIfClosed();
        SybPreparedStatementProxy sybPreparedStatementProxy = null;
        try {
            SybPreparedStatement sybPreparedStatement = (SybPreparedStatement)this._realConn.prepareStatement(string);
            sybPreparedStatementProxy = new SybPreparedStatementProxy(sybPreparedStatement, this._realConn);
            this.rememberPreparedStatements(sybPreparedStatementProxy);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return sybPreparedStatementProxy;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkIfClosed();
        SybPreparedStatementProxy sybPreparedStatementProxy = null;
        try {
            SybPreparedStatement sybPreparedStatement = (SybPreparedStatement)this._realConn.prepareStatement(string, n, n2);
            sybPreparedStatementProxy = new SybPreparedStatementProxy(sybPreparedStatement, this._realConn);
            this.rememberPreparedStatements(sybPreparedStatementProxy);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return sybPreparedStatementProxy;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkIfClosed();
        SybPreparedStatementProxy sybPreparedStatementProxy = null;
        try {
            SybPreparedStatement sybPreparedStatement = (SybPreparedStatement)this._realConn.prepareStatement(string, n);
            sybPreparedStatementProxy = new SybPreparedStatementProxy(sybPreparedStatement, this._realConn);
            this.rememberPreparedStatements(sybPreparedStatementProxy);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return sybPreparedStatementProxy;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkIfClosed();
        SybPreparedStatementProxy sybPreparedStatementProxy = null;
        try {
            SybPreparedStatement sybPreparedStatement = (SybPreparedStatement)this._realConn.prepareStatement(string, nArray);
            sybPreparedStatementProxy = new SybPreparedStatementProxy(sybPreparedStatement, this._realConn);
            this.rememberPreparedStatements(sybPreparedStatementProxy);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return sybPreparedStatementProxy;
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkIfClosed();
        SybPreparedStatementProxy sybPreparedStatementProxy = null;
        try {
            SybPreparedStatement sybPreparedStatement = (SybPreparedStatement)this._realConn.prepareStatement(string, stringArray);
            sybPreparedStatementProxy = new SybPreparedStatementProxy(sybPreparedStatement, this._realConn);
            this.rememberPreparedStatements(sybPreparedStatementProxy);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return sybPreparedStatementProxy;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkIfClosed();
        SybPreparedStatementProxy sybPreparedStatementProxy = null;
        try {
            SybPreparedStatement sybPreparedStatement = (SybPreparedStatement)this._realConn.prepareStatement(string, n, n2, n3);
            sybPreparedStatementProxy = new SybPreparedStatementProxy(sybPreparedStatement, this._realConn);
            this.rememberPreparedStatements(sybPreparedStatementProxy);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return sybPreparedStatementProxy;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.cancel();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Capture createCapture() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.createCapture();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public String getSessionID() throws SQLException {
        this.checkIfClosed();
        try {
            return this._realConn.getSessionID();
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, boolean bl) throws SQLException {
        this.checkIfClosed();
        SybPreparedStatementProxy sybPreparedStatementProxy = null;
        try {
            SybPreparedStatement sybPreparedStatement = (SybPreparedStatement)this._realConn.prepareStatement(string, bl);
            sybPreparedStatementProxy = new SybPreparedStatementProxy(sybPreparedStatement, this._realConn);
            this.rememberPreparedStatements(sybPreparedStatementProxy);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return sybPreparedStatementProxy;
    }

    @Override
    public void regNoWatch(String string) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.regNoWatch(string);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void regWatch(String string, SybEventHandler sybEventHandler, int n) throws SQLException {
        this.checkIfClosed();
        try {
            this._realConn.regWatch(string, sybEventHandler, n);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._realConn.setSybMessageHandler(sybMessageHandler);
    }

    @Override
    public SybMessageHandler getSybMessageHandler() {
        return this._realConn.getSybMessageHandler();
    }

    protected boolean wasClosed() {
        return this._wasClosed;
    }

    protected void rememberStatement(Statement statement) {
        this._openStatements.add(statement);
    }

    protected void rememberPreparedStatements(SybPreparedStatementProxy sybPreparedStatementProxy) {
        this._openPreparedStatements.add(sybPreparedStatementProxy);
    }

    protected void rememberCallableStatements(SybCallableStatementProxy sybCallableStatementProxy) {
        this._openCallableStatements.add(sybCallableStatementProxy);
    }

    protected void removeStatement(Statement statement) {
        if (this._openStatements != null) {
            this._openStatements.remove(statement);
        }
    }

    protected void removeRememberPreparedStatements(SybPreparedStatementProxy sybPreparedStatementProxy) {
        this._openPreparedStatements.remove(sybPreparedStatementProxy);
    }

    protected void removeRememberCallableStatements(SybCallableStatementProxy sybCallableStatementProxy) {
        this._openCallableStatements.remove(sybCallableStatementProxy);
    }

    protected void closeRememberedStatements() throws SQLException {
        for (SybStatement sybStatement : this._openStatements) {
            if (sybStatement.isClosed()) continue;
            sybStatement.closeImplicitly();
        }
        this._openStatements.clear();
    }

    protected void closeRememberedPreparedStatements() throws SQLException {
        for (SybPreparedStatementProxy sybPreparedStatementProxy : this._openPreparedStatements) {
            if (sybPreparedStatementProxy.isClosed()) continue;
            sybPreparedStatementProxy.closeImplicitly();
        }
        this._openPreparedStatements.clear();
    }

    protected void closeRememberedCallableStatements() throws SQLException {
        for (SybCallableStatementProxy sybCallableStatementProxy : this._openCallableStatements) {
            if (sybCallableStatementProxy.isClosed()) continue;
            sybCallableStatementProxy.closeImplicitly();
        }
        this._openCallableStatements.clear();
    }

    @Override
    public com.sybase.jdbcx.SybPreparedStatement copyPreparedStatement(com.sybase.jdbcx.SybPreparedStatement sybPreparedStatement) throws SQLException {
        com.sybase.jdbcx.SybPreparedStatement sybPreparedStatement2;
        this.checkIfClosed();
        try {
            if (sybPreparedStatement instanceof SybPreparedStatementProxy) {
                SybPreparedStatement sybPreparedStatement3 = ((SybPreparedStatementProxy)sybPreparedStatement).getSybPreparedStatement();
                sybPreparedStatement2 = this._realConn.copyPreparedStatement(sybPreparedStatement3);
            } else {
                sybPreparedStatement2 = this._realConn.copyPreparedStatement(sybPreparedStatement);
            }
            this.rememberStatement(sybPreparedStatement2);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return sybPreparedStatement2;
    }

    @Override
    public com.sybase.jdbcx.SybCallableStatement copyCallableStatement(com.sybase.jdbcx.SybCallableStatement sybCallableStatement) throws SQLException {
        com.sybase.jdbcx.SybCallableStatement sybCallableStatement2;
        this.checkIfClosed();
        try {
            if (sybCallableStatement instanceof SybCallableStatementProxy) {
                SybCallableStatement sybCallableStatement3 = ((SybCallableStatementProxy)sybCallableStatement).getSybCallableStatement();
                sybCallableStatement2 = this._realConn.copyCallableStatement(sybCallableStatement3);
            } else {
                sybCallableStatement2 = this._realConn.copyCallableStatement(sybCallableStatement);
            }
            this.rememberStatement(sybCallableStatement2);
        }
        catch (SQLException sQLException) {
            this.testConnection(sQLException);
            throw sQLException;
        }
        return sybCallableStatement2;
    }

    private void checkIfClosed() throws SQLException {
        if (this._wasClosed) {
            ErrorMessage.raiseError("JZ0C0");
        }
    }

    private void testConnection(SQLException sQLException) {
        boolean bl = true;
        try {
            bl = this._realConn.isClosed();
        }
        catch (SQLException sQLException2) {
            // empty catch block
        }
        if (bl) {
            this._realConn.notifyConnectionListeners(sQLException);
        }
    }

    private boolean checkLocalTransaction(String string) throws SQLException {
        SybXAResource sybXAResource = (SybXAResource)((SybXAConnection)this._realConn).getXAResource();
        if (!sybXAResource.isLocalTransactionOK()) {
            try {
                ErrorMessage.raiseWarning(sybXAResource instanceof SybXAResource11 ? "01S10" : "01S09", string);
            }
            catch (SQLException sQLException) {
                this._realConn.chainWarnings(sQLException);
            }
            return false;
        }
        return true;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "public Array createArrayOf(String typeName, Object[] elements)");
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this._realConn.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this._realConn.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "public NClob createNClob()");
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "public SQLXML createSQLXML()");
        return null;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "public Struct createStruct(String typeName, Object[] attributes)");
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this._realConn.getClientInfo();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        return this._realConn.getClientInfo(string);
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        return this._realConn.isValid(n);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this._realConn.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        this._realConn.setClientInfo(string, string2);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t = null;
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage.raiseError("JZ031", clazz.getName(), classCastException);
        }
        return t;
    }
}

