/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.jdbc.ProtocolManager;
import com.sybase.jdbc4.jdbc.SecureStore;
import com.sybase.jdbc4.jdbc.SecureStoreLoginInformation;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.jdbc.SybUrlProvider;
import com.sybase.jdbc4.jdbc.SybUrlProviderImplBase;
import com.sybase.jdbc4.utils.ASAUDPUtil;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;

public class SybUrlManager
extends SybUrlProviderImplBase {
    public static final String KEYWORD_JDBC = "jdbc";
    public static final String KEYWORD_SYBASE = "sybase";
    public static final String KEYWORD_SAP = "sapase";
    public static final String KEYWORD_LDAP = "ldap";
    public static final String KEYWORD_JNDI = "jndi";
    public static final String KEYWORD_SQLINI = "file";
    public static final String PACKAGE_PREFIX = "com.sybase.jdbc4.";
    private static final String JNDI_PROVIDER = "jdbc.SybJndiProvider";
    private static final String SQLINI_PROVIDER = "jdbc.SybSqlIniProvider";
    private Properties _userProps = null;
    private String _url = null;
    private String _providerName = null;
    private String _urlRest = null;

    public SybUrlManager(String string, Properties properties, SybProperty sybProperty) throws SQLException {
        this._url = string;
        this._sybProps = sybProperty;
        this._userProps = properties;
        this._hostportList = new Vector();
        this.validateUrl();
    }

    public SybUrlProvider getUrlProvider() throws SQLException {
        int n;
        String string = PACKAGE_PREFIX;
        SybUrlProvider sybUrlProvider = null;
        String string2 = null;
        if (this._providerName == null) {
            return null;
        }
        string2 = this._providerName.equals(KEYWORD_JNDI) ? ((n = this._urlRest.indexOf(":")) == -1 ? KEYWORD_LDAP : this._urlRest.substring(0, n)) : this._providerName;
        if (string2.equals(KEYWORD_LDAP)) {
            string = string + JNDI_PROVIDER;
            sybUrlProvider = this.loadProvider(string);
        } else if (string2.equals(KEYWORD_SQLINI)) {
            this._providerName = "Tds";
            string = string + SQLINI_PROVIDER;
            sybUrlProvider = this.loadProvider(string);
        } else {
            sybUrlProvider = this;
        }
        if (this._userProps == null && this._sybProps == null) {
            if (string2.equals(KEYWORD_LDAP) || string2.equals(KEYWORD_SQLINI)) {
                return sybUrlProvider;
            }
            sybUrlProvider.init(this._providerName, this._urlRest, this._userProps, this._sybProps);
        } else {
            sybUrlProvider.init(this._providerName, this._urlRest, this._userProps, this._sybProps);
        }
        return sybUrlProvider;
    }

    private SybUrlProvider loadProvider(String string) throws SQLException {
        SybUrlProvider sybUrlProvider = null;
        try {
            sybUrlProvider = (SybUrlProvider)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            ErrorMessage.raiseError("JZ0D7", string, exception.toString(), exception);
        }
        return sybUrlProvider;
    }

    @Override
    public void init(String string, String string2, Properties properties, SybProperty sybProperty) throws SQLException {
        String string3;
        String string4 = null;
        String string5 = null;
        if (string.equals("shm")) {
            if (sybProperty != null) {
                sybProperty.setProperty(31, "com.sybase.shmem.ShmemSocketFactory");
            }
            string = "Tds";
        }
        this._protocol = SybUrlManager.loadProtocol(string);
        if (string2 != null) {
            int n = string2.indexOf(47);
            int n2 = string2.indexOf(63);
            int n3 = string2.indexOf(44);
            if (n > -1 && n < n2) {
                string5 = string2.substring(0, n);
                this._dbName = string2.substring(n + 1, n2);
                try {
                    string4 = URLDecoder.decode(string2.substring(n2 + 1), System.getProperty("file.encoding"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else if (n2 > -1 && (n > n2 || n == -1)) {
                string5 = string2.substring(0, n2);
                try {
                    string4 = URLDecoder.decode(string2.substring(n2 + 1), System.getProperty("file.encoding"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else if (n > -1 && n2 == -1) {
                string5 = string2.substring(0, n);
                this._dbName = string2.substring(n + 1);
            } else {
                string5 = string2;
            }
            if (n3 > -1 && (n3 < n2 || n3 < n || n == -1 && n2 == -1)) {
                string5 = this.setHostPort(string5, n3);
            }
        }
        if (string4 != null && sybProperty != null) {
            this._sybProps.parsePropertyString(string4);
        }
        this._hostportList.addElement(string5);
        if (this._sybProps != null && this._sybProps.getString(115) != null) {
            this.setSecureStoreValues(this._sybProps.getString(115));
        }
        if (this._sybProps != null && (string3 = this._sybProps.getString(73)) != null) {
            ASAUDPUtil aSAUDPUtil = new ASAUDPUtil();
            String string6 = aSAUDPUtil.lookupServer(string3);
            this._hostportList.clear();
            this._hostportList.addElement(string6);
        }
    }

    private void setSecureStoreValues(String string) throws SQLException {
        boolean bl;
        SecureStoreLoginInformation secureStoreLoginInformation = SecureStore.getLoginInformation(string);
        String string2 = secureStoreLoginInformation.getLocation();
        String string3 = secureStoreLoginInformation.getUsername();
        char[] cArray = secureStoreLoginInformation.getCred();
        String string4 = secureStoreLoginInformation.getDatabaseName();
        String string5 = this._sybProps.getString(60);
        String string6 = this._sybProps.getString(3);
        boolean bl2 = this._dbName != null && !this._dbName.equals("");
        boolean bl3 = string5 != null && !string5.equals("");
        boolean bl4 = string6 != null && !string6.equals("");
        boolean bl5 = string2 != null && !string2.equals("");
        boolean bl6 = bl = string4 != null && !string4.equals("");
        if (bl5) {
            int n = string2.lastIndexOf(58);
            int n2 = string2.indexOf(47);
            if (n == -1) {
                ErrorMessage.raiseError("JZ003", string2);
            }
            if (n2 > -1) {
                boolean bl7;
                String string7 = string2.substring(n2 + 1);
                boolean bl8 = bl7 = !string7.equalsIgnoreCase("");
                if (bl7 && bl2 && !string7.equalsIgnoreCase(this._dbName)) {
                    ErrorMessage.raiseError("JZSCF");
                }
                if (bl3 && !string5.equalsIgnoreCase(this._dbName)) {
                    ErrorMessage.raiseError("JZSCF");
                }
                this._dbName = string7.equalsIgnoreCase("") ? this._dbName : string7;
                String string8 = string2.substring(0, n2);
                String string9 = string2 = string8.equals("") ? string2 : string8;
            }
            if (this._hostportList.size() >= 1 && ((String)this._hostportList.get(0)).equals("")) {
                this._hostportList.remove(0);
            }
            if (this._hostportList.size() >= 1 && !((String)this._hostportList.get(0)).equals(string2)) {
                ErrorMessage.raiseError("JZSCF");
            }
            this._hostportList.clear();
            this._hostportList.add(string2);
        }
        if (bl4) {
            ErrorMessage.raiseError("JZSCF");
        }
        this._sybProps.setConnProperty("USER", string3, false, false);
        if (cArray != null) {
            this._sybProps.setConnProperty("PASSWORD", new String(cArray), false, false);
        }
        if (bl) {
            if (bl2 && !string4.equalsIgnoreCase(this._dbName)) {
                ErrorMessage.raiseError("JZSCF");
            }
            if (bl3 && !string5.equalsIgnoreCase(string4)) {
                ErrorMessage.raiseError("JZSCF");
            }
            this._dbName = string4;
        }
    }

    private String setHostPort(String string, int n) {
        String string2 = null;
        while (n > -1) {
            string2 = string.substring(0, n);
            this._hostportList.addElement(string2);
            if ((n = (string = string.substring(n + 1, string.length())).indexOf(44)) != -1) continue;
            return string;
        }
        return string2;
    }

    public static Protocol loadProtocol(String string) throws SQLException {
        String string2 = PACKAGE_PREFIX + string.toLowerCase() + "." + string;
        return ProtocolManager.getProtocol(string2);
    }

    private void validateUrl() throws SQLException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(this._url));
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(58, 58);
        try {
            if (streamTokenizer.nextToken() != -3) {
                return;
            }
            if (streamTokenizer.sval.compareTo(KEYWORD_JDBC) != 0) {
                return;
            }
            if (streamTokenizer.nextToken() != -3) {
                return;
            }
            if (streamTokenizer.sval.compareTo(KEYWORD_SYBASE) != 0 && streamTokenizer.sval.compareTo(KEYWORD_SAP) != 0) {
                return;
            }
            if (streamTokenizer.nextToken() != -3) {
                ErrorMessage.raiseError("JZ0D4", this._url);
            }
            this._providerName = streamTokenizer.sval;
            try {
                streamTokenizer.whitespaceChars(0, 0);
                streamTokenizer.resetSyntax();
                streamTokenizer.wordChars(0, 255);
                if (streamTokenizer.nextToken() == -3) {
                    this._urlRest = streamTokenizer.sval.substring(1);
                }
            }
            catch (IOException iOException) {
                this._urlRest = null;
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException(iOException.toString());
            throw sQLException;
        }
    }
}

